/*
 * Soya3D tutorial
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
Lesson 3 : moving around
You'll learn how to move element and to convert coordinates from a frame to another.
In this lesson, the camera will be moveable with the keyboard :
  LEFT  rotate the camera to the left.
  RIGHT rotate to the right.
  UP    move forward.
  down  move backward.

For pedagogic purpose again, we'll use the shape created in lesson 2!
*/

package opale.soya.tutorial;

import opale.soya.*;              // contains the basic stuff (initialization,...).
import opale.soya.awt.*;          // contains the GUI stuff (RenderingCanvas, RenderingFrame,...).
import opale.soya.soya2d.*;       // contains the 2D stuff (Texturing and Material).
import opale.soya.soya3d.*;       // contains the 3D stuff (A lot of things).
import opale.soya.soya3d.model.*; // contains the modeling stuff (Shape,...).

import java.awt.event.*;

/*
The Lesson3 is a rendering frame.
*/
public class Lesson3 extends RenderingFrame {
  public static void main(String[] args) { (new Lesson3()).setVisible(true); }

  public Lesson3() {
    super(320, 200);

    Soya.init(this);

    scene = new Environment3D();
    scene.setAmbientColor(.5f, .5f, .5f);

    Shape.path = getClass().getResource("").getFile();

    /*
    Load the shape created in lesson 2.
    */
    Shape pyramid = null;
    try { pyramid = Shape.get("pyramid"); }
    catch(Exception e) { System.out.println("Can't find shape pyramid. you must do Lesson2 before Lesson3, in order to create the pyramid."); e.printStackTrace(); }
    
    Volume3D volume = new Volume3D(pyramid);
    scene.add(volume);
    
    Light3D light = new Light3D();
    scene.add(light);
    light.move(-1f, -.2f, 1.1f);
    /*
    Sets the light's color to red.
    */
    light.setColor(1f, 0f, 0f);
    
    Camera3D camera = new Camera3D();
    scene.add(camera);
    camera.move(0f, -.3f, 5f);
    
    this.setRenderer(camera);
    
    /*
    Set the camera into a private field, in order to access it later...
    You can try to set it to volume.
    */
    eye = camera;
    //eye = volume;
    
    addKeyListener(keyListener);
    
    repaint();
  }
  private Environment3D scene;
  private GraphicalElement3D eye;

  private KeyListener keyListener = new KeyAdapter() {
    public void keyPressed(KeyEvent e) {
      Vector v;
      switch(e.getKeyCode()) {
        case e.VK_UP:
          /*
          Move forward the camera of 0.3 step.

          Creates a vector with the given coordinates (0, 0, 0.3) into the given frame (eye).
          In soya, a position is always described with 3 coordinates AND their frame.
          A camera is an AtomicElement3D, so it implements the Position interface and the Frame
          interface.
          A frame is defined with 3 vectors : (1, 0, 0) is the right and (-1, 0, 0) is the left,
                                              (0, 1, 0) is the up    and ( 0,-1, 0) is the bottom,
                                              (0, 0,-1) is the front and ( 0, 0, 1) is the back.
          */
          v = new Vector(0f, 0f, -0.3f, eye);
          /*
          Translate the camera with the vector v. The addVector method comes from the Position
          interface (It translates point and make vector addition for a vector).
          Soya automaticaly perform coordinates converting from the eye frame to its parent
          frame (the scene). (If you want to disable frame convertion, set the frame property
          of a position to null).
          */
          eye.addVector(v);
          break;
        case e.VK_DOWN:
          /*
          Move backward the camera of 0.3 step.
          */
          v = new Vector(0f, 0f, 0.3f, eye);
          eye.addVector(v);
					break;
        case e.VK_LEFT:
          /*
          Rotates the camera to left of 15 degrees. A camera is a DirectionnalElement3D, like
          world, volume or light, so it implements the Orientation interface (see the class graph).
          You can use rotateVertical for vertical rotation, rotateIncline for rotating around
          the z axis, and rotate(vector, angle) for other rotation.
          */
          eye.rotateLateral( 15f);
					break;
        case e.VK_RIGHT:
          /*
          Rotates the camera to right of 15 degrees.
          */
          eye.rotateLateral(-15f);
          break;
      }
      render();
    }
  };
}
