/*
 * Soya3D tutorial
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
Lesson 6 : Events
In this lesson, you'll learn how to receive property change events from a unique
Opale.Soya objects.
The next lesson will be about add/remove-event and sub-events.
*/

package opale.soya.tutorial;

/*
First, import a few packages.
*/
import opale.soya.*;                    // contains the basic stuff (initialization,...).
import opale.soya.soya3d.*;             // contains the 3D stuff (A lot of things).
import opale.soya.soya3d.event.*;       // contains the event stuff.
import opale.soya.soya3d.model.*;       // contains the modeling stuff (Shape,...).

import java.beans.*;

/*
The Lesson6 draws nothing at the screen !
*/
public class Lesson6 {
  public static void main(String[] args) {
    /*
    No initialization is required, because we don't render 3D !
    */
    
    /*
    Creates the scene.
    */
    World3D  scene  = new World3D ();
    
    Shape.path = (new Lesson6()).getClass().getResource("").getFile();
    Shape shape = null;
    try { shape = Shape.get("test"); }
    catch(Exception e) { e.printStackTrace(); }
    
    /*
    Creates a volume and adds it in the scene.
    */
    Volume3D volume = new Volume3D(shape);
    scene.add(volume);
    
    /*
    Creates a PropertyChangeListener that will be used for the volume object.
    */
    PropertyChangeListener listenerToVolume = new PropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent e) {
        /*
        Prints the name of the changed property.
        */
        System.out.println("  the " + e.getPropertyName() + " property of the volume object has changed !");
        /*
        Prints if volume has been moved, roted or resized. If so, the PropertyChangeEvent object
        is an instance of the MoveEvent, OrientateEvent or ResizeEvent interface.
        */
        if(e instanceof MoveEvent     ) System.out.println("  ...volume has moved !"       );
        if(e instanceof OrientateEvent) System.out.println("  ...volume has roted !"       );
        if(e instanceof ResizeEvent   ) System.out.println("  ...volume has been resized !");
      }
    };

    /*
    Registers the listener.
    */
    volume.addPropertyChangeListener(listenerToVolume);
    
    /*
    Now, let's change the volume's properties, and see what's happen !
    */
    System.out.println("We are changing the name property of volume...");
    volume.setName("volume");
    
    System.out.println("We are changing the x property of volume...");
    volume.setX(1f);
    
    System.out.println("We are moving volume...");
    volume.move(0f, 0f, 0f);
    
    System.out.println("We are rotating volume...");
    volume.rotateLateral(90f);
    
    System.out.println("We are changing the height property of volume...");
    volume.setHeight(1f);
  }
}
