/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

/**
 * Class for remove event, raised when an element is removed to the collection.
 * 
 * @author Artiste on the Web
 */

public class RemoveEvent extends CollectionEvent {
  /**
   * Create a CollectionRemoveEvent.
   * @param s the source of the event.
   * @param e the removed element.
   */
  public RemoveEvent(Object s, Object e) {
    super(s);
    element = e;
  }

  private Object element;
  /**
   * Used to recover witch element was removed.
   * @return the removed element.
   */
  public Object getElement() {return element; }
}
