/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

/**
 * Interface for objects that have a name, and that can be saved in a file. The file name
 * depend of the name, an extension depending of the class of object, and a path, also depending
 * of the class of object.
 *
 * Such an object can be recovered only from its name.
 * 
 * Examples of PathedObject are materials and shapes.
 *
 * Imagine you create in the GUI editor 2 shapes that use the same material, and you save them
 * in 2 files, and you load them in your app. If materials were saved into the shape files,
 * you have 2 different materials (they have the same properties, but they are not the same
 * object), so it takes more memory and can be slower. If the material was saved in the material
 * path, only its name is saved in the shape files, and only one material will be created.
 * 
 * @author Artiste on the Web
 */

public interface StoredInPathObject extends NamedObject {
  /**
   * Constant written into file if no object was saved.
   */
  public static final int NO_OBJECT_SAVED = 0;
  /**
   * Constant written into file if no object was saved in the path. Only its name is saved in
   * the file.
   */
  public static final int OBJECT_SAVED_IN_PATH = 1;
  /**
   * Constant written into file if the object was saved just after.
   */
  public static final int OBJECT_SAVED_HERE = 2;

  /**
   * Saves this object.
   */
  public void save() throws java.io.IOException;
}
