/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

public class DComplex
implements Cloneable {
    private double x;
    private double y;
    private static DComplex i = new DComplex(0.0, 1.0);

    public DComplex() {
    }

    public DComplex(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public DComplex(DComplex dComplex) {
        this.x = dComplex.x;
        this.y = dComplex.y;
    }

    public final void add(DComplex dComplex) {
        this.x += dComplex.x;
        this.y += dComplex.y;
    }

    public final void sub(DComplex dComplex) {
        this.x -= dComplex.x;
        this.y -= dComplex.y;
    }

    public final void mul(DComplex dComplex) {
        double d = this.x;
        this.x = this.x * dComplex.x - this.y * dComplex.y;
        this.y = this.y * dComplex.x + d * dComplex.y;
    }

    public static DComplex i() {
        return i;
    }

    public final double getRe() {
        return this.x;
    }

    public final double getIm() {
        return this.y;
    }

    public final void setRe(double d) {
        this.x = d;
    }

    public final void setIm(double d) {
        this.y = d;
    }

    public final void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void set(DComplex dComplex) {
        this.x = dComplex.x;
        this.y = dComplex.y;
    }

    public final double norm() {
        return Math.sqrt(this.normSq());
    }

    public final double normSq() {
        return this.x * this.x + this.y * this.y;
    }

    public String toString() {
        return this.x + (this.y < 0.0 ? "-i*" : "+i*") + Math.abs(this.y);
    }

    public boolean equals(Object object) {
        if (object instanceof DComplex) {
            DComplex dComplex = (DComplex)object;
            return this.x == dComplex.x && this.y == dComplex.y;
        }
        return false;
    }

    public Object clone() {
        try {
            DComplex dComplex = (DComplex)super.clone();
            dComplex.x = this.x;
            dComplex.y = this.y;
            return dComplex;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) {
        DComplex dComplex = new DComplex(1.0, -3.0);
        System.err.println(dComplex);
        dComplex.mul(DComplex.i());
        System.err.println(dComplex);
        System.err.println(dComplex.equals(new DComplex(3.0, 1.0)));
    }
}

