package opale.m2d.ker;
import java.awt.geom.AffineTransform;
/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/

/**
* This class extends <code>java.awt.geom.AffineTransform</code> and represents a 2D affine transform. 
* @see <code>java.awt.geom.AffineTransform</code>
* @author O.C.
* @since Opale-2d 0.12
* @version 0.1
*/

public class AffineTransform2D extends AffineTransform
{
    /**
     * Transforms  arrays of double precision which represents coordinates by this transform.
     * The coordinates are stored in two differents arrays starting at zero.
     * @param srcX the array containing the source point coordinates X.
     * @param srcY the array containing the source point coordinates Y.
     * @param dstX the array into which the transformed point coordinates X are returned.
     * @param dstY the array into which the transformed point coordinates Y are returned.
     * @param numPts the number of point objects to be transformed
     */
    public void transform(double[] srcX, double[] srcY, double[] dstX, double[] dstY, int numPts) {
	double[] mat = new double[6];
	getMatrix(mat);
	    while (numPts-- > 0) {
		double x = srcX[numPts];
		double y = srcY[numPts];
		dstX[numPts] = mat[0] * x + mat[2] * y + mat[4];
		dstY[numPts] = mat[1] * x +  mat[3] * y + mat[5];
	    }
	}

}
