/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.m2d.ker.*;
import opale.tools.*;
import java.io.StreamTokenizer;

/**
* Classe contenant des informations graphiques sur les objets de type GData2D. Elle tend la classe InfoObjet et renseigne donc sur les champs contenus dans cette dernire.
* @author O.C.
* @since Opale-2d 0.1
*/
public class InfoData extends InfoObject implements Cloneable
{
//membres privs
private int stylePoint;	//le style de trac d'un point
private int typeGraph;	//type de trac
protected int sizePoint;	//la taille en pixel du point

//les constructeurs publiques
/**
* Constructeur par dfaut: stylePoint = 0; typeGraph = 0, sizePoint = 5;
*/
public InfoData()
	{
	super();
	stylePoint = 0;
	typeGraph = 0;
	sizePoint = 5;
	}

/**
* Le constructeur de copie
* @param InfoLine inf, l'information  copier
*/
public InfoData(InfoData inf)
	{
	super(inf);
	stylePoint = inf.getStylePoint();
	typeGraph = inf.getTypeGraph();
	sizePoint = inf.getSizePoint();
	}


//methodes d'accs, publiques

/**
* Renvoie l'entier dfinissant le style de trac d'un point.
* @return int le style de trac :
* 0 = pas de trc
* 1 = point
* 2 = +
* 3 = X
* 4 = cercle
* 5 = carr
* 6 = diamant
* 7 = triangle haut
* 8 = triangle bas
* 9 = triangle gauche
* 10 = triangle droit
*/
public final int getStylePoint()
	{
	return stylePoint;
	}

/**
* change le style de trac d'un point.
* @param short le nouveau style
*/
public final void setStylePoint(int s)
	{
	stylePoint = s;
	}
/**
* Renvoie la taille en pixel du point
* @return int, la taille 
*/
public int getSizePoint()
	{
	return sizePoint;
	}

/**
* change la taille du point
* @param int size, la nouvelle taille en pixel
*/
public void setSizePoint(int size)
	{
	this.sizePoint = sizePoint;
	}

/**
* Renvoie l'entier dfinissant le style de trac du nuage.
* @return int le style de trac :
* 0 = trac de ligne
* 1 = point seulement
* 2 = barres verticales
* 3 = barres horizontales
* 4 = barres horizontales et verticales
*/
public final int getTypeGraph()
	{
	return typeGraph;
	}

/**
* change le style de trac du nuage.
* @param short le nouveau style
*/
public final void setTypeGraph(int s)
	{
	typeGraph = s;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
	{
	return (InfoData) super.clone();
	}
	catch(InternalError e)
	{
	throw e;
	}
	}
	
public final void writeFileMore(WFile f, Pack2D p)
	{
	f.writeln("\tSYMBOL_POINT " +stylePoint);
	f.writeln("\tSIZE_POINT " +sizePoint);
	f.writeln("\tTYPE8GRAPH " +typeGraph);
	}	
	
public final int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	int type;
	if ( word.equals("SYMBOL_POINT"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		stylePoint = (int) f.nval;
		return 0;
		}
	else if ( word.equals("TYPE_GRAPH"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		typeGraph = (int) f.nval;
		return 0;
		}
	else if ( word.equals("SIZE_POINT"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		sizePoint = (int) f.nval;
		return 0;
		}
	return -1;
		
	}
		
}
