package opale.swools;
/**
* La classe IntTextField tend <code>JTextField</code> et ne permet que la saisie de int.
* @version 1 janvier 2000 
* @author O.C.
*/

import javax.swing.*;
import javax.swing.text.*;

class IntTextDocument extends PlainDocument
{  public void insertString(int offs, String str, 
      AttributeSet a) 
      throws BadLocationException 
   {  if (str == null) return;
      String oldString = getText(0, getLength());
      String newString = oldString.substring(0, offs)
         + str + oldString.substring(offs);
      try
      {  Integer.parseInt(newString + "0");
         super.insertString(offs, str, a);
      }
      catch(NumberFormatException e)
      {  
      }
   }
}

public class IntTextField extends JTextField 
{  public IntTextField(int defval, int size)
   {  super("" + defval, size);
   }
 public IntTextField(int size)
   {  super("" + 0, size);
   }

   protected Document createDefaultModel() 
   {  return new IntTextDocument();
   }

   public boolean isValid()
   {  try
      {  Integer.parseInt(getText());
         return true;
      }
      catch(NumberFormatException e)
      {  return false; 
      }
   }

   public int getValue()
   {  try
      {  return Integer.parseInt(getText());
      }
      catch(NumberFormatException e)
      {  return 0; 
      }
   }
}
