/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.io.IOException;
import opale.m2d.Matrix2D;
import opale.m2d.OIJException;
import opale.m2d.Pack2D;
import opale.tools.Debug;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public final class OIJ
implements Cloneable {
    public static OIJ OIJ_ABSOLUTE = new OIJ();
    private String name;
    private OIJ rep;
    protected double oriX;
    protected double oriY;
    protected double[] I;
    protected double[] J;

    public OIJ() {
        this.name = new String("Sans nom");
        this.rep = OIJ_ABSOLUTE;
        this.oriY = 0.0;
        this.oriX = 0.0;
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = 1.0;
        this.I[1] = 0.0;
        this.J[0] = 0.0;
        this.J[1] = 1.0;
    }

    public OIJ(double d, double d2, double d3, double d4, double d5, double d6) throws OIJException {
        this.name = new String("Sans nom");
        this.rep = OIJ_ABSOLUTE;
        this.oriX = d;
        this.oriY = d2;
        if (!(Math.abs(d3 * d6 - d4 * d5) > 1.0E-15)) {
            throw new OIJException("Erreur \u00e0 la construction d'un rep\u00e8re !");
        }
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = d3;
        this.I[1] = d4;
        this.J[0] = d5;
        this.J[1] = d6;
    }

    public OIJ(OIJ oIJ, double d, double d2, double d3, double d4, double d5, double d6) throws OIJException {
        this.name = new String("Sans nom");
        this.rep = oIJ;
        this.oriX = d;
        this.oriY = d2;
        if (!(Math.abs(d3 * d6 - d4 * d5) > 1.0E-15)) {
            throw new OIJException("Erreur \u00e0 la construction d'un rep\u00e8re !");
        }
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = d3;
        this.I[1] = d4;
        this.J[0] = d5;
        this.J[1] = d6;
    }

    public OIJ(OIJ oIJ) {
        this.rep = oIJ.rep;
        this.oriX = oIJ.oriX;
        this.oriY = oIJ.oriY;
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = oIJ.I[0];
        this.I[1] = oIJ.I[1];
        this.J[0] = oIJ.J[0];
        this.J[1] = oIJ.J[1];
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = new String(string);
    }

    public boolean equals(Object object) {
        if (object instanceof OIJ) {
            OIJ oIJ = (OIJ)object;
            Matrix2D matrix2D = new Matrix2D();
            Matrix2D matrix2D2 = new Matrix2D();
            OIJ.matPassageAbs(oIJ, matrix2D);
            OIJ.matPassageAbs(this, matrix2D2);
            return matrix2D.equals(matrix2D2);
        }
        return false;
    }

    public final double normSq(double d, double d2) {
        return d * d * (this.I[0] * this.I[0] + this.I[1] * this.I[1]) + 2.0 * d * d2 * (this.I[0] * this.J[0] + this.I[1] * this.J[1]) + d2 * d2 * (this.J[0] * this.J[0] + this.J[1] * this.J[1]);
    }

    public final double norm(double d, double d2) {
        return Math.sqrt(this.normSq(d, d2));
    }

    public final double distSq(double d, double d2, double d3, double d4) {
        return this.normSq(d3 - d, d4 - d2);
    }

    public final double dist(double d, double d2, double d3, double d4) {
        return this.norm(d3 - d, d4 - d2);
    }

    public void matPassage(Matrix2D matrix2D) {
        matrix2D.set(0, 0, this.I[0]);
        matrix2D.set(1, 0, this.I[1]);
        matrix2D.set(0, 1, this.J[0]);
        matrix2D.set(1, 1, this.J[1]);
        matrix2D.setV(0, this.oriX);
        matrix2D.setV(1, this.oriY);
    }

    public void matPassage(OIJ oIJ, Matrix2D matrix2D) {
        Matrix2D matrix2D2 = new Matrix2D();
        Matrix2D matrix2D3 = new Matrix2D();
        double[][] dArray = new double[2][2];
        OIJ.matPassageAbs(oIJ, matrix2D2);
        OIJ.matPassageAbs(this, matrix2D3);
        double d = matrix2D2.get(1, 1) * matrix2D2.get(0, 0) - matrix2D2.get(0, 1) * matrix2D2.get(1, 0);
        dArray[0][0] = matrix2D2.get(1, 1) / d;
        dArray[0][1] = -matrix2D2.get(0, 1) / d;
        dArray[1][0] = -matrix2D2.get(1, 0) / d;
        dArray[1][1] = matrix2D2.get(0, 0) / d;
        matrix2D.setV(0, dArray[0][0] * (matrix2D3.getV(0) - matrix2D2.getV(0)) + dArray[0][1] * (matrix2D3.getV(1) - matrix2D2.getV(1)));
        matrix2D.setV(1, dArray[1][0] * (matrix2D3.getV(0) - matrix2D2.getV(0)) + dArray[1][1] * (matrix2D3.getV(1) - matrix2D2.getV(1)));
        matrix2D.set(0, 0, dArray[0][0] * matrix2D3.get(0, 0) + dArray[0][1] * matrix2D3.get(1, 0));
        matrix2D.set(0, 1, dArray[0][0] * matrix2D3.get(0, 1) + dArray[0][1] * matrix2D3.get(1, 1));
        matrix2D.set(1, 0, dArray[1][0] * matrix2D3.get(0, 0) + dArray[1][1] * matrix2D3.get(1, 0));
        matrix2D.set(1, 1, dArray[1][0] * matrix2D3.get(0, 1) + dArray[1][1] * matrix2D3.get(1, 1));
    }

    private static void matPassageAbs(OIJ oIJ, Matrix2D matrix2D) {
        if (oIJ != OIJ_ABSOLUTE) {
            matrix2D.set(0, 0, oIJ.I[0]);
            matrix2D.set(1, 0, oIJ.I[1]);
            matrix2D.set(0, 1, oIJ.J[0]);
            matrix2D.set(1, 1, oIJ.J[1]);
            matrix2D.setV(0, oIJ.oriX);
            matrix2D.setV(1, oIJ.oriY);
            if (oIJ.rep != OIJ_ABSOLUTE) {
                Matrix2D matrix2D2 = new Matrix2D();
                double[][] dArray = new double[2][2];
                dArray[0][0] = matrix2D.get(0, 0);
                dArray[0][1] = matrix2D.get(0, 1);
                dArray[1][0] = matrix2D.get(1, 0);
                dArray[1][1] = matrix2D.get(1, 1);
                OIJ.matPassageAbs(oIJ.rep, matrix2D2);
                matrix2D.set(0, 0, matrix2D2.get(0, 0) * dArray[0][0] + matrix2D2.get(0, 1) * dArray[1][0]);
                matrix2D.set(0, 1, matrix2D2.get(0, 0) * dArray[0][1] + matrix2D2.get(0, 1) * dArray[1][1]);
                matrix2D.set(1, 0, matrix2D2.get(1, 0) * dArray[0][0] + matrix2D2.get(1, 1) * dArray[1][0]);
                matrix2D.set(1, 1, matrix2D2.get(1, 0) * dArray[0][1] + matrix2D2.get(1, 1) * dArray[1][1]);
                dArray[0][0] = matrix2D.getV(0);
                matrix2D.setV(0, matrix2D2.get(0, 0) * matrix2D.getV(0) + matrix2D2.get(0, 1) * matrix2D.getV(1) + matrix2D2.getV(0));
                matrix2D.setV(1, matrix2D2.get(1, 0) * dArray[0][0] + matrix2D2.get(1, 1) * matrix2D.getV(1) + matrix2D2.getV(1));
            }
        } else {
            matrix2D.set(0, 0, 1.0);
            matrix2D.set(1, 0, 0.0);
            matrix2D.set(0, 1, 0.0);
            matrix2D.set(1, 1, 1.0);
            matrix2D.setV(0, 0.0);
            matrix2D.setV(1, 0.0);
        }
    }

    public String toString() {
        return this.name;
    }

    public final void setOrigin(double d, double d2) {
        this.oriX = d;
        this.oriY = d2;
    }

    public final double getOriginX() {
        return this.oriX;
    }

    public final double getOriginY() {
        return this.oriY;
    }

    public final void setI(double d, double d2) throws OIJException {
        if (!(Math.abs(d * this.J[1] - d2 * this.J[0]) > 1.0E-15)) {
            throw new OIJException("erreur");
        }
        this.I[0] = d;
        this.I[1] = d2;
    }

    public final void setJ(double d, double d2) throws OIJException {
        if (!(Math.abs(d * this.I[1] - d2 * this.I[0]) > 1.0E-15)) {
            throw new OIJException("erreur");
        }
        this.J[0] = d;
        this.J[1] = d2;
    }

    public final double getIx() {
        return this.I[0];
    }

    public final double getIy() {
        return this.I[1];
    }

    public final double getJx() {
        return this.J[0];
    }

    public final double getJy() {
        return this.J[1];
    }

    public final void setOIJ(OIJ oIJ) {
        this.rep = oIJ;
    }

    public OIJ getOIJ() {
        return this.rep;
    }

    public void writeFile(WFile wFile, Pack2D pack2D) {
        wFile.writeln("{");
        wFile.writeln("O " + this.oriX + " " + this.oriY);
        wFile.writeln("I " + this.I[0] + " " + this.I[1]);
        wFile.writeln("J " + this.J[0] + " " + this.J[1]);
        wFile.writeln("}");
    }

    public void readFile(RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        int n = rFile.nextToken();
        if (n != -3 || !rFile.sval.equals("{")) {
            throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
        }
        n = rFile.nextToken();
        do {
            if (rFile.sval.equals("O")) {
                n = rFile.nextToken();
                if (n != -2) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                this.oriX = rFile.nval;
                n = rFile.nextToken();
                if (n != -2) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                this.oriY = rFile.nval;
                continue;
            }
            if (rFile.sval.equals("I")) {
                n = rFile.nextToken();
                if (n != -2) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                d = rFile.nval;
                n = rFile.nextToken();
                if (n != -2) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                d2 = rFile.nval;
                continue;
            }
            if (!rFile.sval.equals("J")) continue;
            n = rFile.nextToken();
            if (n != -2) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
            }
            d3 = rFile.nval;
            n = rFile.nextToken();
            if (n != -2) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
            }
            d4 = rFile.nval;
        } while ((n = rFile.nextToken()) != -3 || !rFile.sval.equals("}"));
        try {
            this.setI(d, d2);
            this.setJ(d3, d4);
        }
        catch (OIJException oIJException) {
            throw new MalformedFileException("Impossible de construire un tel rep\u00e8re.");
        }
    }

    public Object clone() {
        try {
            OIJ oIJ = (OIJ)super.clone();
            oIJ.name = this.name;
            oIJ.oriX = this.oriX;
            oIJ.oriY = this.oriY;
            oIJ.rep = this.rep;
            oIJ.I[0] = this.I[0];
            oIJ.I[1] = this.I[1];
            oIJ.J[0] = this.J[0];
            oIJ.J[1] = this.J[1];
            return oIJ;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isDirect() {
        return this.I[0] * this.J[1] - this.I[1] * this.J[0] >= 0.0;
    }

    public static void main(String[] stringArray) throws OIJException {
        OIJ oIJ = new OIJ(0.0, 0.0, -3.0, 1.0, -2.0, 1.0);
        Debug.print("" + oIJ.isDirect());
    }

    static {
        OIJ_ABSOLUTE.setName("OIJ_ABSOLUTE");
    }
}

