/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

import opale.mathtools.DVect;
import opale.mathtools.IFnn;

public final class FixPoint {
    public static double PRECISION = 1.0E-16;
    public static int MAXITERATION = 100;

    public static void solve(IFnn iFnn, int n, DVect dVect, DVect dVect2) {
        int n2 = 0;
        boolean bl = false;
        DVect dVect3 = new DVect(dVect);
        while (n2 < MAXITERATION && !bl) {
            dVect2.set(iFnn.val(dVect3));
            dVect3.sub(dVect2);
            double d = dVect3.norm2Sq() / dVect2.norm2Sq();
            dVect3.set(dVect2);
            if (d < PRECISION) {
                bl = true;
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        DVect dVect = new DVect(2);
        DVect dVect2 = new DVect(2);
        FixPoint.solve(new IFnn(){

            public DVect val(DVect dVect) {
                DVect dVect2 = new DVect(2);
                dVect2.set(0, 1.0 + 0.1 * dVect.get(0) * dVect.get(1) - dVect.get(1));
                dVect2.set(1, 0.5 * dVect.get(0) + 0.5 * dVect.get(0) * dVect.get(1));
                return dVect2;
            }
        }, 2, dVect, dVect2);
        System.err.println(dVect2);
    }
}

