/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix;

import opale.mathtools.DVect;
import opale.tools.Debug;

public final class Matrix {
    private double[][] a;
    private int n;
    private int m;

    public Matrix(int n, int n2) {
        this.m = n2;
        this.n = n;
        this.a = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this.n = dArray.length;
        this.m = dArray[0].length;
        this.a = new double[this.n][this.m];
        Debug.print("n = " + this.n);
        Debug.print("m = " + this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                this.a[n][n2] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public int getRowDim() {
        return this.n;
    }

    public int getColumnDim() {
        return this.m;
    }

    public double get(int n, int n2) {
        Debug.assert(n < this.n && n2 < this.m);
        return this.a[n][n2];
    }

    public void set(int n, int n2, double d) {
        Debug.assert(n < this.n && n2 < this.m);
        this.a[n][n2] = d;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.n, this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                matrix.a[n][n2] = this.a[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public Matrix add(Matrix matrix) {
        Debug.assert(this.n == matrix.n && this.m == matrix.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                double[] dArray = this.a[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] + matrix.a[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public DVect mul(DVect dVect) {
        Debug.assert(this.m == dVect.size());
        DVect dVect2 = new DVect(this.n);
        int n = 0;
        while (n < this.n) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.m) {
                d += this.a[n][n2] * dVect.get(n2);
                ++n2;
            }
            dVect2.set(n, d);
            ++n;
        }
        return dVect2;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                matrix.a[n][n2] = this.a[n2][n];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public double[][] getInternalArray() {
        return this.a;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.n][this.m];
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                dArray[n][n2] = this.a[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.n * this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                double d = this.a[n][n2];
                stringBuffer.append(d + " ");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

