/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix.solver;

import opale.mathtools.DVect;
import opale.matrix.Decomposition;
import opale.matrix.Matrix;
import opale.matrix.Solver;

public class SolverLU
implements Solver,
Decomposition {
    private double[][] LU;
    private int[] pivot;
    private int n;
    private int signepermut;

    public void decomp(Matrix matrix) {
        if (matrix.getRowDim() != matrix.getColumnDim()) {
            throw new IllegalArgumentException("LU decomposition implemented only for square matrix");
        }
        this.n = matrix.getRowDim();
        this.pivot = new int[this.n];
        this.signepermut = 1;
        this.LU = matrix.getArrayCopy();
        int n = 0;
        while (n < this.n) {
            this.pivot[n] = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.n - 1) {
            double d = Math.abs(this.LU[this.pivot[n2]][n2]);
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < this.n) {
                if (Math.abs(this.LU[this.pivot[n4]][n2]) > d) {
                    d = Math.abs(this.LU[this.pivot[n4]][n2]);
                    n3 = n4;
                }
                ++n4;
            }
            if (n3 != n2) {
                int n5 = this.pivot[n2];
                this.pivot[n2] = this.pivot[n3];
                this.pivot[n3] = n5;
                this.signepermut = -this.signepermut;
            }
            double d2 = 1.0 / this.LU[this.pivot[n2]][n2];
            int n6 = n2 + 1;
            while (n6 < this.n) {
                double d3;
                this.LU[this.pivot[n6]][n2] = d3 = this.LU[this.pivot[n6]][n2] * d2;
                int n7 = n2 + 1;
                while (n7 < this.n) {
                    this.LU[this.pivot[n6]][n7] = this.LU[this.pivot[n6]][n7] - d3 * this.LU[this.pivot[n2]][n7];
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public double determinant() {
        double d = this.signepermut;
        int n = 0;
        while (n < this.n) {
            d *= this.LU[this.pivot[n]][n];
            ++n;
        }
        return d;
    }

    public void solve(Matrix matrix, DVect dVect, DVect dVect2) {
        if (this.n != dVect.size() || this.n != dVect2.size()) {
            throw new IllegalArgumentException("matrix and vector dimension are not equals.");
        }
        double[] dArray = dVect.toArray();
        double[] dArray2 = dVect2.toArray();
        int n = 0;
        while (n < this.n) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < n) {
                d += this.LU[this.pivot[n]][n2] * dArray2[n2];
                ++n2;
            }
            dArray2[n] = dArray[this.pivot[n]] - d;
            ++n;
        }
        int n3 = this.n - 1;
        while (n3 >= 0) {
            double d = 0.0;
            int n4 = n3 + 1;
            while (n4 < this.n) {
                d += this.LU[this.pivot[n3]][n4] * dArray2[n4];
                ++n4;
            }
            dArray2[n3] = (dArray2[n3] - d) / this.LU[this.pivot[n3]][n3];
            --n3;
        }
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{4.0, 1.0}, {1.0, 4.0}};
        Matrix matrix = new Matrix(dArrayArray);
        DVect dVect = new DVect(2);
        DVect dVect2 = new DVect(2);
        System.out.println(matrix);
        dVect.set(0, 1.0);
        dVect.set(1, 0.0);
        SolverLU solverLU = new SolverLU();
        solverLU.decomp(matrix);
        System.out.println("det = " + solverLU.determinant());
        solverLU.solve(null, dVect, dVect2);
        System.out.println(dVect2);
        System.out.println(matrix);
    }
}

