package opale.m2d.component2d;
import opale.m2d.*;
import java.awt.*;
import java.awt.event.*;

/**
* @since Opale-2d 0.11
*/
public class Frame2D extends Frame  
{
private Pack2D pack;
private	CoordSystem vue;
private	GAxis2D axes;

/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
*/
public Frame2D()
	{
	setTitle("Opale v0.11 - Frame 2d");
	setSize(300,300);

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
		
	add(new DrawPanel(),"Center");	
	vue = new LinLinCS(OIJ.OIJ_ABSOLUTE,0,0,300,300);

	pack = new Pack2D();
	pack.add(OIJ.OIJ_ABSOLUTE,"oij_abs");
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	}

/**
* Renvoie la rfrence  l'instance de Pack2D contenu dans l'objet courant Frame2D.
* @return Pack2D, l'instance de Pack2D.
*/
public Pack2D getPack2D()
	{
	return pack;
	}

/**
* Renvoie la rfrence  l'instance de GAxis2D contenu dans l'objet courant JFrame2D.
* @return GAxis2D, l'instance de GAxis2D.

*/
public GAxis2D getAxis()
	{
	return axes;
	}
	
/**
* Renvoie la rfrence au systme de coordonnes contenu dans l'objet courant JFrame2D.
* @return CoordSystem, l'instance de CoordSystem.
*/
public CoordSystem getCS()
	{
	return vue;
	}



private class DrawPanel extends Panel
{
DrawPanel()
	{
	addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(0,0,getWidth(),getHeight());
			vue.autoadjust();
			repaint();
			}
		});

	}

public void paint(Graphics g)
	{
	Pen2D c = new Pen2D(g,vue);
	axes.draw(c);
	c.clip();
		
	pack.draw(c);
	}
	
}



public static void main(String[] arg)
	{
	Frame2D f =new Frame2D();
	f.show();
	}
	
}


