package opale.module2d.objet2d;

import opale.module2d.noyau2d.*;
/**
* Cette classe reprsente un polygone du plan.
* @author O.C.
* @version 0.1
*/

public class GPolygon extends Polygon implements GObject2D
{
//membres privs
private InfoObjet info; //Info sur le polygone

/**
* Constructeur avec nb de Sommets et liste des sommets.
* @param int n, le nombre de sommets.
* @param Point2D[] p, la liste des sommets.
*/
public GPolygon(int n,Point2D[] p)
	{
	super(n,p);
	info = new InfoObjet();
	}

/**
* Constructeur avec nb de Sommets, liste des sommets et un nom.
* @param int n, le nombre de sommets.
* @param Point2D[] p, la liste des sommets.
* @param String nom, le nom
*/
public GPolygon(int n,Point2D[] p, String nom)
	{
	super(n,p);
	info = new InfoObjet();
	info.setName(nom);
	}

//definition des methodes de l'interface ObjetGraphique2D

public void draw(Pen2D crayon)
	{
	int i;

	for (i=0;i<nbPoint-1;i++)
		crayon.drawLine(sommets[i].getX(),sommets[i].getY(),sommets[i+1].getX(),sommets[i+1].getY());
	crayon.drawLine(sommets[i].getX(),sommets[i].getY(),sommets[0].getX(),sommets[0].getY());
	}
	
public InfoObjet getInfo()
	{
	return info;
	}




public String toString()
	{
	String s="Polygone "+info.getName();
	return s;
	}

}

