/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* This class implements the fix point method to solve the equation f(x) = x, where f is a function R^n->R^n.
* @since Opale-Mathtools 0.12
* @author O.C.
* @date 01/2001
*/
public final class FixPoint
{
/**
* This value represents the precision of the solution.
*/
public static double PRECISION = 1.e-16;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
public static int MAXITERATION = 100;

/**
* To call this method runs the resolution of the equation f(x) = x.
* @param IFnn, the function f.
* @param int, the dimension of the definition's spaces of the function.
* @param DVect x0, the initial condition for the algorithm.
* @param DVect sol, the solution.
*/ 
public static void solve(IFnn f, int n, DVect x0, DVect sol)
	{
	//tester la taille de DVect avec n ?
	
	int i=0,sortie=0;
//	double[] tab = new double[n];
	double cvg;

	//initialisation des conditions initiales
	DVect x = new DVect(x0);	
	
	while ( (i<MAXITERATION) && (sortie == 0) )
		{
		sol.set(f.val(x));
		x.sub(sol);
		cvg =   x.norm2Sq()/sol.norm2Sq();
		
		// prepare the next iteration
		x.set(sol);
		if ( cvg < PRECISION ) 
			sortie = 1;
		i++;
		}
	}
	
public static void main(String[] arg)
	{
	DVect x0 = new DVect(2);
	DVect sol = new DVect(2);
	FixPoint.solve(new IFnn()
		{
		public DVect val(DVect x)
			{
			DVect y =new DVect(2);
			y.set(0,1.+0.1*x.get(0)*x.get(1)-x.get(1));
			y.set(1,0.5*x.get(0)+0.5*x.get(0)*x.get(1));
			return y;
			}
		},2,x0,sol);
	System.err.println(sol);
	}
}

