/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.matrix.solver;

import opale.tools.Debug;
import opale.mathtools.DVect;
import opale.matrix.*;

/**
* This class implements Jacobi solver according to the book "Analyse matricielle applique  l'art de l'ingnieur", Lascaux & Thodor, Ed. Masson.
* @author O.C.
* @date 05/2001
*/


public class SolverJacobi implements IterativeSolver
{

private int n,signepermut;

/**
* Solve Ax=b.
* @param Matrix A.
*/
public void solve(Matrix A,DVect b, DVect x)
	{
	int n = A.getRowDim();
	if (n != A.getColumnDim() ) throw new IllegalArgumentException("Jacobi solver implemented only for square matrix");
	if ((n != b.size()) || (n != x.size())) throw new IllegalArgumentException("matrix and vector dimension are not equals.");
	
	double[][] AA=A.getInternalArray();
	double[] B = b.toArray();
	double[] X = x.toArray();
	double[] TEMP = new double[X.length];
	double normr=1;
	int it=0;
	
	while ((it++ < MAXITER) && (normr>PRECISION))
	{
	normr=0.;
	for (int i=0;i<n;i++)
		{
		double c=B[i];
		for (int j=0;j<n;j++)
			c-=AA[i][j]*X[j];
		normr=Math.max(Math.abs(c),normr);
		TEMP[i] = X[i]+c/AA[i][i];
		}
	
	for (int i=0;i<n;i++)
		X[i]=TEMP[i];
if (Debug.On) Debug.print("residu = "+normr);		
	}
if (Debug.On) Debug.print("n iter = "+it);		
/*	for (int i=0;i<n;i++)
		{
		double c=B[i];
		for (int j=0;j<i;j++)
			c-=AA[i][j]*X[j];
		for (int j=i+1;j<n;j++)
			c-=AA[i][j]*X[j];
		TEMP[i] = c/AA[i][i];
		}
	for (int i=0;i<n;i++)
		X[i]=TEMP[i];	*/	
		
		
	}
	

public static void main(String[] arg)
	{
	double[][] tab = { {4,1}, {1,4} };
	Matrix A=new Matrix(tab);
	
	DVect b=new DVect(2);
	DVect x=new DVect(2);

	System.out.println(A);
	
	b.set(0,1);
	b.set(1,0);
	
	
	SolverJacobi jac = new SolverJacobi();
	jac.solve(A,b,x);
		

	
	System.out.println(x);
	}
	
			
}
	
	
