/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.tools;
import java.io.*;

/**
* Cette classe encapsule des methodes pour lire les types de base stock dans un fichier et sous forme ASCII.
* @author O.C.
* @since Opale-Tools 0.1
*/

public class RFile extends StreamTokenizer
{

private String name;
public RFile(String name) throws IOException
	{
	super(new FileReader(name));
	this.name =name;
	wordChars(33,255);
	slashStarComments(false);
	slashSlashComments(true);
	}
	
public RFile(InputStream inp) throws IOException
	{
	super(new BufferedReader(new InputStreamReader(inp)));
	this.name = inp.toString();
	wordChars(33,255);
	slashStarComments(false);
	slashSlashComments(true);
	}
	
	

public String toString()
	{
	return name;
	}


//tests
public static void main(String[] arg) 
	{
	try
	{
	WFile wf = new WFile("test.txt");
	wf.writeString("I");
	wf.writeString("SQRT(I)");
	wf.writeln("I*I");
	
	for (int i=0;i<15;i++)
		{
		wf.print(i+" ");
		wf.writeDouble(Math.sqrt(i));
		wf.writelnDouble(i*i);
		}
	wf.close();
	}
	catch(IOException evt)
		{
		}	  
	
	try
	{
	RFile rf = new RFile("test.txt");
	int cpt=0;
	while (rf.nextToken() != StreamTokenizer.TT_EOF)
		{
		if (rf.ttype == rf.TT_NUMBER) System.out.print(rf.nval);
		if (rf.ttype == rf.TT_WORD) System.out.print(rf.sval);
		System.out.print((cpt==2)?"\n" : " ");
		cpt = (cpt+1)%3;
		}	
	}
	catch(IOException evt)
		{
		}	  
	}

}

