import opale.tools.*;
import opale.mathtools.*;
import opale.ode.ker.*;
import opale.ode.scheme.*;
import opale.m2d.ker.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class OsciAmorti
	{
	
	public static void main(String[] arg)	
	{
	// Rsolution des quations  de l'oscillateur amorti 1D

	Problem pb = new Problem(2);	// problme en dimension 2
	RK ts = new RK();		// avec la mthode de Runge Kutta classique
	
	DVect cd = new DVect(2);	// vecteur pour la condition initiale

	// valeurs par dfaut
	double Masse = 1.;	// la masse
	double Raideur = 1.; 	// la raideur
	double Camort = 1;	// coeff d'amortissement
	

	// aucun tests n'est fait sur la validit des arguments passs !!
	if (arg.length == 3)
		{
		Masse = Double.parseDouble(arg[0]);
		Raideur = Double.parseDouble(arg[1]);
		Camort = Double.parseDouble(arg[2]);
		}

	// variables finales car utilises dans une classe interne	
	final double Omega = Math.sqrt(Raideur/Masse);	// la pulsation
	final double Ksi = Camort/(2*Omega*Masse);	// amortissement rduit
	
	ts.setNstep(1000);		//nombre de pas en temps : 1000
	ts.set(0,20);			// tude sur l'intervalle en temps (0;10)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,x.get(1));		//x'(t,x,y) = y
				y.set(1,-2*Ksi*Omega*x.get(1)-Omega*Omega*x.get(0));	//y'(t,x,y) = -2*ksi*omega*y-omega^2*x
				return y;
				}
			}
		);

	pb.setTS(ts);	//on associe le schma en temps
	
	// on rsoud le systme avec deux cds intiales :
	// 1) deplacement initial >0 ; vitesse initiale positive
	// 2) deplacement initial >0 ; vitesse initiale ngative
	double[][][] sol=new double[2][3][1000];
	cd.set(0,1);	// cd intiale
	cd.set(1,1);
	pb.setInit(cd);
	pb.solve();	// rsolution
	sol[0]=pb.toTab();	// on stocke la solution 

	cd.set(0,1);	// cd intiale
	cd.set(1,-1);
	pb.setInit(cd);
	pb.solve();	// rsolution
	sol[1]=pb.toTab();	// on stocke la solution 
		
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D();	// ouverture d'une JFrame2D
	String titre="Oscillateur amorti - ";
	if (Ksi <1.)
		titre+=" cas sous critique";
	else if (Ksi > 1.)
		titre+=" cas surcritique";
	else if (Ksi==1.)
		titre+=" cas critique";
	
	jf.setTitle(titre); // le titre
	jf.setSize(600,500); // taille intiale de la fen\^etre
	jf.getAxis().drawScale(false); // pas d'chelles sur les axes.
	OIJ repere = new OIJ();	// le repre du dessin
	jf.getCS().set(-1,21,-2,2);	//les coordonnes min/max
	jf.getPack2D().add(repere,"repere");
	GData2D gsol = new GData2D(repere);	
	GData2D gsol2 = new GData2D(repere);	  
	gsol2.getInfo().setColor(java.awt.Color.red);
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	gsol.set(1000,sol[0][0],sol[0][1]);	
	gsol2.set(1000,sol[1][0],sol[1][1]);	
	jf.getPack2D().add(gsol,"sol");	// ajout dans un Pack2D
	jf.getPack2D().add(gsol2,"sol2");	// ajout dans un Pack2D
	jf.show();	//affichage  l'cran
	
	
	
	}

}
