#!/bin/sh
# Permits to create an archive opale.jar with specified modules.
# WARNING : the compilation is not very fast because of the use of 'find ... -exec javac ...' to compile the sources. 

 
if [ -z "$JC" ]
then
JC='jikes -encoding iso-8859-1 -nowarn'  #Jikes 
#JC=javac # or javac (Sun, Ibm, Blackdown ...)
fi

# destination directory
DEST=$OPALE_DIR/arch

if [ -z "$OPALE_DIR" ]
then
	echo "OPALE_DIR not initialized !"
	exit -1
fi

usage() {
	echo "Usage : obuildarch.sh <module>"
	echo "where <module> is the list of modules to archive."
	exit -1
	}
	
if [ $# == 0 ] 
then
 usage
fi

echo "The compiler is " $JC

if [  -d $DEST/opale ]
then
rm -rf $DEST/opale
fi
mkdir $DEST/opale/

#tools,swools and mathtools 
cp -rf $OPALE_DIR/opale/tools $DEST/opale
cp -rf $OPALE_DIR/opale/swools $DEST/opale
cp -rf $OPALE_DIR/opale/mathtools $DEST/opale

$JC -d $DEST $OPALE_DIR/opale/tools/*.java 
$JC -d $DEST $OPALE_DIR/opale/swools/*.java 
$JC -d $DEST $OPALE_DIR/opale/mathtools/*.java 

for i in $@
do
echo "building opale.$i ..."
#Copy all the files to be sure to have resources files.
	 cp -rf $OPALE_DIR/opale/$i $DEST/opale

# compiles
	find $OPALE_DIR/opale/$i -name '*.java' -exec $JC -d $DEST {} \;
done

# deletes *.java files
find $DEST/opale -name '*.java' -exec rm -rf  {}  \;


echo "Building the archive opale.jar"
cd $DEST
jar cfm opale.jar $OPALE_DIR/utils/sh/Manifest opale
