/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

import opale.mathtools.Sort;
import opale.tools.Debug;

public final class DVect
implements Cloneable {
    private double[] x;
    private int n;

    public DVect(int n) {
        this.x = new double[n];
        this.n = n;
        n = 0;
        while (n < this.n) {
            this.x[n] = 0.0;
            ++n;
        }
    }

    public DVect(int n, double[] dArray) {
        this.x = new double[n];
        this.n = n;
        n = 0;
        while (n < this.n) {
            this.x[n] = dArray[n];
            ++n;
        }
    }

    public DVect(double[] dArray) {
        this.n = dArray.length;
        this.x = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.x[n] = dArray[n];
            ++n;
        }
    }

    public DVect(DVect dVect) {
        this.n = dVect.n;
        this.x = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.x[n] = dVect.x[n];
            ++n;
        }
    }

    public void set(DVect dVect) {
        Debug.assert(this.n == dVect.n);
        int n = 0;
        while (n < this.n) {
            this.x[n] = dVect.x[n];
            ++n;
        }
    }

    public void set(int n, double d) {
        Debug.assert(n < this.n);
        this.x[n] = d;
    }

    public void set(double[] dArray) {
        Debug.assert(this.n == dArray.length);
        int n = 0;
        while (n < this.n) {
            this.x[n] = dArray[n];
            ++n;
        }
    }

    public double get(int n) {
        Debug.assert(n < this.n && n >= 0);
        return this.x[n];
    }

    public void get(double[] dArray) {
        Debug.assert(this.n == dArray.length);
        int n = 0;
        while (n < this.n) {
            dArray[n] = this.x[n];
            ++n;
        }
    }

    public double[] toArray() {
        return this.x;
    }

    public int getSize() {
        return this.n;
    }

    public int size() {
        return this.n;
    }

    public void add(DVect dVect) {
        Debug.assert(this.n == dVect.n);
        int n = 0;
        while (n < this.n) {
            int n2 = n;
            this.x[n2] = this.x[n2] + dVect.x[n];
            ++n;
        }
    }

    public void add(double[] dArray) {
        Debug.assert(this.n == dArray.length);
        int n = 0;
        while (n < this.n) {
            int n2 = n;
            this.x[n2] = this.x[n2] + dArray[n];
            ++n;
        }
    }

    public void acc(double d, DVect dVect) {
        Debug.assert(this.n == dVect.n);
        int n = 0;
        while (n < this.n) {
            int n2 = n;
            this.x[n2] = this.x[n2] + d * dVect.x[n];
            ++n;
        }
    }

    public void sub(DVect dVect) {
        Debug.assert(this.n == dVect.n);
        int n = 0;
        while (n < this.n) {
            this.x[n] = this.x[n] - dVect.x[n];
            ++n;
        }
    }

    public void acc(DVect dVect, double d) {
        Debug.assert(this.n == dVect.n);
        int n = 0;
        while (n < this.n) {
            int n2 = n;
            this.x[n2] = this.x[n2] + d * dVect.x[n];
            ++n;
        }
    }

    public void mul(double d) {
        int n = 0;
        while (n < this.n) {
            int n2 = n++;
            this.x[n2] = this.x[n2] * d;
        }
    }

    public double norm2Sq() {
        double d = 0.0;
        int n = 0;
        while (n < this.n) {
            d += this.x[n] * this.x[n];
            ++n;
        }
        return d;
    }

    public double norm2() {
        return Math.sqrt(this.norm2Sq());
    }

    public double normInf() {
        double d = 0.0;
        int n = 0;
        while (n < this.n) {
            if (Math.abs(this.x[n]) > d) {
                d = Math.abs(this.x[n]);
            }
            ++n;
        }
        return d;
    }

    public double norm1() {
        double d = 0.0;
        int n = 0;
        while (n < this.n) {
            d += Math.abs(this.x[n]);
            ++n;
        }
        return d;
    }

    public double normp(int n) {
        if (n == 0) {
            return -1.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.n) {
            d += Math.pow(Math.abs(this.x[n2]), n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double getMax() {
        return Sort.getMax(this.n, this.x);
    }

    public double getMin() {
        return Sort.getMin(this.n, this.x);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.n - 1) {
            string = string + this.x[n] + "\n";
            ++n;
        }
        string = string + this.x[this.n - 1];
        return string;
    }

    public DVect copy() {
        DVect dVect = new DVect(this);
        return dVect;
    }

    public Object clone() {
        try {
            DVect dVect = (DVect)super.clone();
            dVect.n = this.n;
            dVect.x = new double[this.n];
            int n = 0;
            while (n < this.n) {
                dVect.x[n] = this.x[n];
                ++n;
            }
            return dVect;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

