/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import opale.mathtools.DVect;
import opale.mathtools.ParseFunction;
import opale.ode.Equation;
import opale.ode.ODE;
import opale.ode.ObjectODE;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public class SEquation
extends ObjectODE
implements Equation {
    private int dim;
    private String[] fonc;
    private ParseFunction[] parser;
    private double[] resu;

    public boolean setFunc(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 3) {
            return false;
        }
        this.dim = stringArray.length;
        this.parser = new ParseFunction[this.dim];
        this.resu = new double[this.dim];
        this.fonc = new String[this.dim];
        int n = 0;
        while (n < this.dim) {
            this.parser[n] = new ParseFunction();
            if (this.parser[n].parse(stringArray[n])) {
                boolean[] blArray = this.parser[n].getVariables();
                if (this.dim == 1 && (blArray[1] || blArray[2]) || this.dim == 2 && blArray[2]) {
                    return false;
                }
            } else {
                return false;
            }
            this.fonc[n] = stringArray[n];
            ++n;
        }
        return true;
    }

    public String getFunc(int n) {
        if (n >= 0 && n < 3) {
            return this.fonc[n];
        }
        return null;
    }

    public int dim() {
        return this.dim;
    }

    public DVect derivs(double d, DVect dVect) {
        try {
            if (this.dim == 1) {
                this.resu[0] = this.parser[0].getResult(d, dVect.get(0), 0.0, 0.0);
            } else if (this.dim == 2) {
                this.resu[0] = this.parser[0].getResult(d, dVect.get(0), dVect.get(1), 0.0);
                this.resu[1] = this.parser[1].getResult(d, dVect.get(0), dVect.get(1), 0.0);
            } else if (this.dim == 3) {
                this.resu[0] = this.parser[0].getResult(d, dVect.get(0), dVect.get(1), dVect.get(2));
                this.resu[1] = this.parser[1].getResult(d, dVect.get(0), dVect.get(1), dVect.get(2));
                this.resu[2] = this.parser[2].getResult(d, dVect.get(0), dVect.get(1), dVect.get(2));
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Erreur de parsing !!!");
        }
        DVect dVect2 = new DVect(this.resu);
        return dVect2;
    }

    public String toString() {
        String string = "";
        if (this.dim == 1) {
            string = "f(t,x) = " + this.fonc[0];
        } else if (this.dim == 2) {
            string = "f1(t,x,y) = " + this.fonc[0] + "\n";
            string = string + "f2(t,x,y) = " + this.fonc[1];
        } else if (this.dim == 3) {
            string = "f1(t,x,y,z) = " + this.fonc[0] + "\n";
            string = string + "f2(t,x,y,z) = " + this.fonc[1] + "\n";
            string = string + "f3(t,x,y,z) = " + this.fonc[2];
        }
        return string;
    }

    public int readKeyWord(String string, RFile rFile, ODE oDE) throws IOException, MalformedFileException {
        if (string.equals("f(t,x)=")) {
            this.dim = 1;
            int n = rFile.nextToken();
            if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction  : " + rFile.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
            }
            String[] stringArray = new String[]{rFile.sval.substring(1, rFile.sval.length() - 1)};
            if (!this.setFunc(stringArray)) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction : " + stringArray[0]);
            }
            return 0;
        }
        if (string.equals("f1(t,x,y)=")) {
            this.dim = 2;
            int n = rFile.nextToken();
            if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction  : " + rFile.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
            }
            String[] stringArray = new String[2];
            stringArray[0] = rFile.sval.substring(1, rFile.sval.length() - 1);
            n = rFile.nextToken();
            string = rFile.sval;
            n = rFile.nextToken();
            if (string.equals("f2(t,x,y)=")) {
                if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                    throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction  : " + rFile.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
                }
            } else {
                return -1;
            }
            stringArray[1] = rFile.sval.substring(1, rFile.sval.length() - 1);
            if (!this.setFunc(stringArray)) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction");
            }
            return 0;
        }
        if (string.equals("f1(t,x,y,z)=")) {
            this.dim = 3;
            int n = rFile.nextToken();
            if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction  : " + rFile.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
            }
            String[] stringArray = new String[3];
            stringArray[0] = rFile.sval.substring(1, rFile.sval.length() - 1);
            n = rFile.nextToken();
            string = rFile.sval;
            n = rFile.nextToken();
            if (string.equals("f2(t,x,y,z)=")) {
                if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                    throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction  : " + rFile.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
                }
            } else {
                return -1;
            }
            stringArray[1] = rFile.sval.substring(1, rFile.sval.length() - 1);
            n = rFile.nextToken();
            string = rFile.sval;
            n = rFile.nextToken();
            if (string.equals("f3(t,x,y,z)=")) {
                if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                    throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction  : " + rFile.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
                }
            } else {
                return -1;
            }
            stringArray[2] = rFile.sval.substring(1, rFile.sval.length() - 1);
            if (!this.setFunc(stringArray)) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction");
            }
            return 0;
        }
        return -1;
    }

    public void writeFile(WFile wFile, ODE oDE) {
        wFile.writeln("{");
        if (this.dim == 1) {
            wFile.writeln("f(t,x)= '" + this.fonc[0] + "'");
        } else if (this.dim == 2) {
            wFile.writeln("f1(t,x,y)= '" + this.fonc[0] + "'");
            wFile.writeln("f2(t,x,y)= '" + this.fonc[1] + "'");
        } else if (this.dim == 3) {
            wFile.writeln("f1(t,x,y,z)= '" + this.fonc[0] + "'");
            wFile.writeln("f2(t,x,y,z)= '" + this.fonc[1] + "'");
            wFile.writeln("f3(t,x,y,z)= '" + this.fonc[2] + "'");
        }
        wFile.writeln("}");
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{3.0, 1.0, -5.0};
        DVect dVect = new DVect(dArray);
        SEquation sEquation = new SEquation();
        String[] stringArray2 = new String[]{"x*z-y-3*t", "2*x+y*z+t", "-2*x+y-z*t"};
        System.err.println(sEquation.setFunc(stringArray2));
        System.err.println(sEquation.derivs(-34.0, dVect).get(2));
        System.err.println(sEquation);
    }
}

