/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* Implements the bisection method for find the root of a function.
* The algorithm is conformed with the book numerical recipes in C.
* If the precision is not reached, then the number of iterations is MAXITERATION and the variable NITER  is set to -1.
* @author O.C.
* @date 01/2001
* @since Opale-Mathtools 0.12
*/
public class Bisection extends RootFinder1D
{
/**
* Solves equation f(x) = 0 by bisection's method. The root must be bracketed between x0 and x1.
*/
public double find(IyFx f, double x0, double x1)
	{
	double dx,ff, root, fmid, xmid;
	
	ff = f.val(x0);
	fmid = f.val(x1);
	
	if (ff*fmid >=0) {NITER=-1; return 0.;}
	//throw new RootFinderException("Root must be between x0 and x1 in bisection's method");
	if ( ff < 0.)
		{
		root = x0;
		dx = x1-x0;
		}
	else
		{
		root = x1;
		dx = x0-x1;
		}	
	for (NITER=1;NITER<=MAXITERATION;NITER++)
		{
		fmid = f.val(xmid = root+(dx*=.5));
		if (fmid<=0.) root = xmid;
		if ((Math.abs(dx)<PRECISION) || (fmid == 0.)) return root;
		}
	NITER=-1;	// precision not reached !
	return root;
	//throw new RootFinderException("Too many iterations in bisection's method : precision not reached");
		
	}
}
