import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;


public class PredateurProie
	{
	
	public static void main(String[] arg)
	{
	// Rsolution des problmes de Vander Pool avec 15 conditions initiales diffrentes
	Problem pb = new Problem(2);
	ExplicitEuler ts = new ExplicitEuler();
	
	DVect cd = new DVect(2);
	
	ts.setNstep(1000);
	ts.set(0,1);
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,5*x.get(0)*(x.get(1)-3));//-0.1*x[0]*x[0];
				y.set(1,5*x.get(1)*(3-x.get(0)));
				return y;
				}
			}
		);

	pb.setTS(ts);
	
	// on rsoud le systme de Vander Pol avec les 5 conditions initiales diffrentes 
	int i;
	for (i=0;i<5;i++)
		{
		cd.set(0,5+i);
		cd.set(1,3*i+0.5);
		pb.setInit(cd);
		pb.solve();
		try
		{
		WFile wf = new WFile("resu"+i+".txt");
		pb.writeSol(wf);
		wf.writeln("");
		wf.close();
		}
		catch(java.io.IOException e)
		{}	
		}
	
	
	
	}

}
