/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix;

import opale.mathtools.DVect;

public final class BandMatrix
implements Cloneable {
    private double[] a;
    private int size;
    private int band;

    public BandMatrix(int n, int n2) {
        if (n2 % 2 == 0) {
            ++n2;
        }
        this.band = n2;
        this.size = n;
        this.a = new double[n * n2];
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeOfBand() {
        return this.band;
    }

    public double get(int n, int n2) {
        return this.a[n * this.band + (this.band - 1) / 2 + n2 - n];
    }

    public void set(int n, int n2, double d) {
        this.a[n * this.band + (this.band - 1) / 2 + n2 - n] = d;
    }

    public int getPosition(int n, int n2) {
        return n * this.band + (this.band - 1) / 2 + n2 - n;
    }

    public BandMatrix copy() {
        BandMatrix bandMatrix = new BandMatrix(this.size, this.band);
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.band) {
                bandMatrix.a[n * this.band + n2] = this.a[n * this.band + n2];
                ++n2;
            }
            ++n;
        }
        return bandMatrix;
    }

    public BandMatrix add(BandMatrix bandMatrix) {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.band) {
                int n3 = n * this.band + n2;
                this.a[n3] = this.a[n3] + bandMatrix.a[n * this.band + n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public void add(int n, int n2, double d) {
        int n3 = n * this.band + (this.band - 1) / 2 + n2 - n;
        this.a[n3] = this.a[n3] + d;
    }

    public DVect mul(DVect dVect) {
        DVect dVect2 = new DVect(this.size);
        int n = (this.band - 1) / 2;
        int n2 = 0;
        while (n2 < this.size) {
            double d = 0.0;
            int n3 = Math.max(0, n2 - n);
            int n4 = Math.min(this.size - 1, n2 + n);
            int n5 = n3;
            while (n5 <= n4) {
                d += this.a[this.getPosition(n2, n5)] * dVect.get(n5);
                ++n5;
            }
            dVect2.set(n2, d);
            ++n2;
        }
        return dVect2;
    }

    public double[] getInternalArray() {
        return this.a;
    }

    public double[] getArrayCopy() {
        double[] dArray = new double[this.size * this.band];
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.band) {
                dArray[n * this.band + n2] = this.a[n * this.band + n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public String toString() {
        int n = (this.band - 1) / 2;
        StringBuffer stringBuffer = new StringBuffer(this.size * this.band);
        int n2 = 0;
        while (n2 < this.size) {
            double d;
            int n3 = Math.max(0, n2 - n);
            int n4 = Math.min(this.size - 1, n2 + n);
            int n5 = 0;
            while (n5 < n3) {
                d = 0.0;
                stringBuffer.append(d + "\t");
                ++n5;
            }
            n5 = n3;
            while (n5 <= n4) {
                d = this.get(n2, n5);
                stringBuffer.append(d + "\t");
                ++n5;
            }
            n5 = n4 + 1;
            while (n5 < this.size) {
                d = 0.0;
                stringBuffer.append(d + "\t");
                ++n5;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            BandMatrix bandMatrix = (BandMatrix)super.clone();
            bandMatrix.size = this.size;
            bandMatrix.band = this.band;
            bandMatrix.a = this.getArrayCopy();
            return bandMatrix;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) {
        int n = 6;
        BandMatrix bandMatrix = new BandMatrix(n, 3);
        int n2 = 0;
        while (n2 < n) {
            bandMatrix.set(n2, n2, 2.0);
            if (n2 > 0) {
                bandMatrix.set(n2, n2 - 1, -1.0);
            }
            if (n2 < n - 1) {
                bandMatrix.set(n2, n2 + 1, -1.0);
            }
            ++n2;
        }
        System.out.println(bandMatrix);
    }
}

