public abstract class ElFi
{
private int dim, NS, NN;	//dimension, nb de sommets, nb de noeuds
protected double[][] xs;	//coords des sommets
protected double[][] xn;	//coords des noeuds
 
public ElFi(int d, int ns, int nn)
	{
	dim = d;
	NS=ns;
	NN = nn;
	xs = new double[NS][dim];
	xn = new double[NN][dim];
	}
	 
public boolean setXs(int n, double[] x)
	{
	if ( (x.length == dim) && (n>=0) && (n<NS) )
		{
		int i;
		for (i=0;i<dim;i++)
			this.xs[n][i] = x[i];
		return true;
		}
	return false;
	}

    /**
     * Tests if the specified coordinates are inside the boundary of the 
     * <code>Shape</code>.
     * @param x,&nbsp;y the specified coordinates
     * @return <code>true</code> if the <code>Shape</code> contains the
     * specified coordinates; <code>false</code> otherwise.
     */
    public boolean contains(double[] x) {
	}
	int hits = 0;

	double lastx = xs[NS - 1];
	double lasty = ys[NS - 1];
	double curx, cury;

	// Walk the edges of the polygon
	for (int i = 0; i < NS; lastx = curx, lasty = cury, i++) {
	    curx = xs[i];
	    cury = ys[i];

	    if (cury == lasty) {
		continue;
	    }

	    int leftx;
	    if (curx < lastx) {
		if (x >= lastx) {
		    continue;
		}
		leftx = curx;
	    } else {
		if (x >= curx) {
		    continue;
		}
		leftx = lastx;
	    }

	    double test1, test2;
	    if (cury < lasty) {
		if (y < cury || y >= lasty) {
		    continue;
		}
		if (x < leftx) {
		    hits++;
		    continue;
		}
		test1 = x - curx;
		test2 = y - cury;
	    } else {
		if (y < lasty || y >= cury) {
		    continue;
		}
		if (x < leftx) {
		    hits++;
		    continue;
		}
		test1 = x - lastx;
		test2 = y - lasty;
	    }

	    if (test1 < (test2 / (lasty - cury) * (lastx - curx))) {
		hits++;
	    }
	}

	return ((hits & 1) != 0);
    }



/**
* Cette mthode dfinit les fonctions de base de l'lement.
* @param int i, le numro de la fonction de base (0<=i<NN).
* @param double[] x, le point  valuer.
* @return , la valeur de la fonction.
* @since Opale 0.11
*/
abstract public double phi(int i, double[] x);
}
