package opale.mathtools.parser;

/**
* This class makes it possible to add an user function that will be recognised by the parser. It uses a string definition of the function and so an user can can create dynamicaly an function from a string definition : unlike the class <code>UnaryFunction</code>, this class will be used rather in the conception of a graphical user interface.
* @author OC
*/
public class SUnaryFunction extends UnaryFunction
{
private Parser p;
private String x,keyword;

private SUnaryFunction() {}

/**
* This constructor instanciate an user function : it must specify the keyword for the recognisation, the string definition of the variable and the string definition of the function. 
* <P> For instance, to define the function f(x) = 2*cos(x) : <code> SUnaryFunction myFunc = new SUnaryFunction("f","x","2*cos(x)")</code>
*/
public SUnaryFunction(String keyword,String var, String s)
	{
	this.keyword = keyword;
	p = new Parser(s);
	p.addVar(x=var);
	p.parseString();
	}
	
/**
* Evaluate the function at the point x.
*/
public double eval(double x)
	{
	p.setVar(this.x,x);
	return p.eval();
	}
/**
* Returns the keyword of this function
*/
public String keyword() { return keyword; }

}
