/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix;

import opale.mathtools.DVect;
import opale.tools.Debug;

public final class SymMatrix
implements Cloneable {
    private double[] a;
    private int n;
    private int size;

    public SymMatrix(int n) {
        this.n = n;
        this.size = n * (n + 1) / 2;
        this.a = new double[this.size];
    }

    public int getDim() {
        return this.n;
    }

    public double get(int n, int n2) {
        Debug.assert(n < this.n && n2 < this.n);
        if (n2 < n) {
            return this.a[n * (n + 1) / 2 + n2];
        }
        return this.a[n2 * (n2 + 1) / 2 + n];
    }

    public void set(int n, int n2, double d) {
        Debug.assert(n < this.n && n2 < this.n);
        if (n2 < n) {
            this.a[n * (n + 1) / 2 + n2] = d;
        } else {
            this.a[n2 * (n2 + 1) / 2 + n] = d;
        }
    }

    public SymMatrix copy() {
        SymMatrix symMatrix = new SymMatrix(this.n);
        int n = 0;
        while (n < this.size) {
            symMatrix.a[n] = this.a[n];
            ++n;
        }
        return symMatrix;
    }

    public void add(SymMatrix symMatrix) {
        Debug.assert(this.n == symMatrix.n);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 <= n) {
                int n3 = n * (n + 1) / 2 + n2;
                this.a[n3] = this.a[n3] + symMatrix.a[n * (n + 1) / 2 + n2];
                ++n2;
            }
            ++n;
        }
    }

    public DVect mul(DVect dVect) {
        Debug.assert(this.n == dVect.size());
        DVect dVect2 = new DVect(this.n);
        int n = 0;
        while (n < this.n) {
            double d = 0.0;
            int n2 = 0;
            while (n2 <= n) {
                d += this.a[n * (n + 1) / 2 + n2] * dVect.get(n2);
                ++n2;
            }
            int n3 = n + 1;
            while (n3 < this.n) {
                d += this.a[n3 * (n3 + 1) / 2 + n] * dVect.get(n3);
                ++n3;
            }
            dVect2.set(n, d);
            ++n;
        }
        return dVect2;
    }

    public double[] getInternalArray() {
        return this.a;
    }

    public double[] getArrayCopy() {
        double[] dArray = new double[this.size];
        int n = 0;
        while (n < this.size) {
            dArray[n] = this.a[n];
            ++n;
        }
        return dArray;
    }

    public String toString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(this.n * this.n);
        int n2 = 0;
        while (n2 < this.n) {
            int n3 = 0;
            while (n3 <= n2) {
                double d = this.a[n++];
                stringBuffer.append(d);
                stringBuffer.append(" ");
                ++n3;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            SymMatrix symMatrix = (SymMatrix)super.clone();
            symMatrix.n = this.n;
            symMatrix.size = this.size;
            symMatrix.a = this.getArrayCopy();
            return symMatrix;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) {
        SymMatrix symMatrix = new SymMatrix(3);
        symMatrix.set(0, 0, 1.0);
        symMatrix.set(0, 2, 2.0);
        symMatrix.set(2, 1, -15.0);
        SymMatrix symMatrix2 = (SymMatrix)symMatrix.clone();
        symMatrix.set(1, 2, 10.0);
        System.out.println(symMatrix);
        System.out.println(symMatrix2);
    }
}

