/*
 * Decompiled with CFR 0.152.
 */
package opale.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.InvalidIdException;
import opale.tools.OpaleSet;
import opale.tools.Stdio;

public abstract class OpaleObject
implements Cloneable {
    private static OpaleSet global_set = new OpaleSet();
    private String id = null;

    protected OpaleObject() {
        Stdio.printerrln("New OpaleObject : " + this.getClass().getName());
    }

    public final String getId() {
        return this.id;
    }

    public final int setId(String string) {
        if (this.id == null) {
            if (global_set.contains(this.id)) {
                throw new InvalidIdException("This id already exists !!!");
            }
            this.id = string;
            global_set.add(this);
            return 1;
        }
        Debug.print("This Opale object  " + this + " has already an identificator !!! Its id is not changed : " + this.getId());
        return -1;
    }

    public void read(StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        int n = streamTokenizer.nextToken();
        if (n != -3 || !streamTokenizer.sval.equals("{")) {
            throw new InvalidFormatException("Stream of data  non valid !!");
        }
        n = streamTokenizer.nextToken();
        do {
            if (n != -3) {
                throw new InvalidFormatException("Stream of data non valid : we wait a keyword !!");
            }
            if (this.readKeyWord(streamTokenizer.sval, streamTokenizer, opaleSet) != -1) continue;
            throw new InvalidFormatException("Stream of data non valid : error reading a keyword " + streamTokenizer.sval + " !!");
        } while ((n = streamTokenizer.nextToken()) != -3 || !streamTokenizer.sval.equals("}"));
    }

    public abstract int readKeyWord(String var1, StreamTokenizer var2, OpaleSet var3) throws IOException, InvalidFormatException;

    public abstract void write(PrintWriter var1, OpaleSet var2) throws InvalidFormatException;

    public Object clone() {
        try {
            OpaleObject opaleObject = (OpaleObject)super.clone();
            opaleObject.id = null;
            return opaleObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

