package opale.m2d;
import opale.tools.*;
import opale.m2d.*;
import java.io.*;

/**
* @since Opale-2d 0.15
* @author O.C.
*/

public abstract class MarkType extends OpaleObject implements  Cloneable
{
protected int marksize;

public MarkType()
	{
	marksize=10;
	}

public abstract void draw(Pen2D c,double x, double y);

public void setMarksize(int size)
	{
	marksize = Math.abs(size);
	}
public int getMarksize()
	{
	return marksize;
	}
	
/**
* Write size of this MarkType in a stream. This method is inherited from OpaleObject
*/
public void write(PrintWriter f,OpaleSet pack) throws InvalidFormatException
	{
	f.println("{ SIZE "+marksize+" }");
	}

public  int readKeyWord(String word, StreamTokenizer f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	int type;
	if ( word.equals("SIZE"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		marksize = (int) f.nval;
		if (marksize < 0 ) throw new InvalidFormatException("Size must be positive integer !!");
		return 0;
		}
	return -1;
		
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	/*try
		{*/
		MarkType p = (MarkType) super.clone();
		p.marksize = marksize;
		return p;
		//}
	/*catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError(""+e);
		}*/
	}
	
public String toString() { return "MarkType Size = "+marksize;}
 
public static void main(String[] arg)
	{
	opale.m2d.marktype.ClassicPoint cp = new opale.m2d.marktype.ClassicPoint();
	System.out.println(cp.getMarksize());
	opale.m2d.marktype.ClassicPoint cpp = (opale.m2d.marktype.ClassicPoint)cp.clone();
	cp.setMarksize(3);
	System.out.println(cpp.getMarksize());
	System.out.println(cp.getMarksize());


	System.out.println(cp.getClass().getName());
	}
	    
    
}
