package opale.tools;

import java.io.*;


/**
* Many classes of Opale extend this abstract class. It makes it possible to read/write in a stream with an user language.
* @author O.C.
* @since Opale-tools 0.14 (OpaleV1b5)
*/
public abstract class OpaleObject  implements Cloneable
{
private static OpaleSet global_set = new OpaleSet();
private String id=null;
//public static  int PRECEDENCE ;

protected OpaleObject()
	{
	if (Debug.On) Stdio.printerrln("New OpaleObject : "+this.getClass().getName());
	}

/**
* Return the string identifcator of this object.
* @return String, the id.
*/
public final String getId() { return id;}

/**
* Set the id of this object. It's not possible to set an id if the object has already an id : in this case this method return -1. Moreover if the id exists, an instance of <code>opale.tools.InvalidIdException</code> is thrown. In other case it returns a positive integer. 
* @return String, the id.
*/
public final int setId(String i)
        {
        if (id == null)
                {
                if (global_set.contains(id)) throw new InvalidIdException("This id already exists !!!");
                else
                        {
                        this.id = i;
                        global_set.add(this);
                        }
                return 1;
		}
       // else throw new InvalidIdException("This OpaleObject "+this+" has already an identificator !!!");
        else 
		{
		if (Debug.On) Debug.print("This Opale object  "+this+" has already an identificator !!! Its id is not changed : "+this.getId());
		return -1;
		}
	}
        
/**
* This method read the data in a file at format '.opa' . It calls the abstract method <code>readKeyword</code> implemented in the derivated classes.
* @param StreamTokenizer f, stream to read.
* @param OpaleSet session, the group of object that are read in the stream.
*/
public void read( StreamTokenizer f,OpaleSet session)  throws java.io.IOException,InvalidFormatException
	{
	int type;
	type = f.nextToken();	//on lit la premiere '{'
	if ( (type !=StreamTokenizer.TT_WORD) || !f.sval.equals("{") ) throw new InvalidFormatException("Stream of data  non valid !!");
	type = f.nextToken();	
	do
		{
		if (type != StreamTokenizer.TT_WORD)  throw new InvalidFormatException("Stream of data non valid : we wait a keyword !!");
		if (readKeyWord(f.sval,f,session) == -1) throw new InvalidFormatException("Stream of data non valid : error reading a keyword "+f.sval+" !!");
		type = f.nextToken();
		}
	while ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("}") );
	
	}
	
/**
* Abstract method to read a key word in a file '*.ode'.
* @param String s, key word to read.
* @param StreamTokenizer f, stream to read.
* @param OpaleSet session,  the group of 'Opale' object
* @return int, 0 if the key word is correct, -1 otherwise.
*/
public abstract int readKeyWord(String s, StreamTokenizer f,OpaleSet session)  throws java.io.IOException, InvalidFormatException ; 

/**
* Abstrcat method to write the current object in a stream.
* @param printWriter f, a stream.
* @param OpaleSet session,   the set of 'Opale' object. 
*/
public abstract void write(PrintWriter f, OpaleSet session) throws InvalidFormatException ;

/**
* Return a "clone object" but with an id set at null pointer. 
* @return Object
*/
public Object clone()
	{
	try
		{
		OpaleObject copy =  (OpaleObject) super.clone();
		copy.id=null;
		return copy;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError();
		}
	}

}
