package otests.ode.VanDerPol;

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class VanDerPol implements OTest
	{
	JFrame2D jf = new JFrame2D();
	
	public  void run(String path)
	{
	// Rsolution des problmes de Vander Pool avec 15 conditions initiales diffrentes

	Problem pb = new Problem(2);	//problme en dimension 2
	RK ts = new RK();		// avec la mthode de RungeKutta classique
	
	DVect cd = new DVect(2);	// vecteur pour la condition initiale
	
	ts.setNstep(1000);		//nombre de pas en temps : 1000
	ts.set(0,10);			// tude sur l'intervalle en temps (0;10)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,x.get(1)-x.get(0)*x.get(0)*x.get(0)+x.get(0));		//x'(t,x,y) = y-x*x+x
				y.set(1,-x.get(0));				//y'(t,x,y) = -x
				return y;
				}
			}
		);

	pb.setTS(ts);	//on associe le schma en temps
	
	// on rsoud le systme de Vander Pol avec les 15 conditions initiales diffrentes 
	double[][][] sol = new double[15][3][1000];
	int i;
	for (i=0;i<5;i++)
		{
		cd.set(0,5);
		cd.set(1,-3+i);
		pb.setInit(cd);
		pb.solve();
		sol[i]=pb.toArray();
		}
	for (i=6;i<10;i++)
		{
		cd.set(0,-5);
		cd.set(1,i-5);
		pb.setInit(cd);
		pb.solve();
		sol[i]=pb.toArray();
		}
	for (i=11;i<15;i++)
		{
		cd.set(0,0.1*Math.cos(i));
		cd.set(1,0.1*Math.sin(i));
		pb.setInit(cd);
		pb.solve();
		sol[i]=pb.toArray();
		}
		
		
	// A chaque fois, la solution du problme i est stocke dans la variable sol[i]
	
	
	
	// On affiche le rsultat avec le module 2d d'Opale
	jf.setTitle("Systme de Van der Pol - Opale-ODE 0.1");
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-6,6,-6,6);
	jf.getPack2D().add(repere,"repere");
	GData2D[] gsol = new GData2D[15];
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	
	//affichage des 15 solutions
	for (i=0;i<15;i++)
		{
		gsol[i] = new GData2D(repere);
		gsol[i].set(1000,sol[i][1],sol[i][2]);
		jf.getPack2D().add(gsol[i],"sol"+i);
		}
	jf.show();
	
	}

public void stop()
	{
	jf.dispose();
	}
	

}
