/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Vector;
import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.ObjectODE;
import opale.ode.SEquation;
import opale.ode.TimeScheme;
import opale.tools.Chronometer;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.Stdio;
import opale.tools.WFile;

public final class Problem
extends ObjectODE {
    public final boolean PRINT = false;
    private TimeScheme sch;
    private Equation eqn;
    private DVect cdinit;
    private Vector inco;
    private Vector times;
    private int dim;
    private boolean issolve = false;

    public Problem() {
        this.dim = 1;
        this.cdinit = new DVect(this.dim);
    }

    public Problem(int n) {
        this.dim = Math.max(n, 1);
        this.cdinit = new DVect(this.dim);
    }

    public void solve() {
        this.issolve = false;
        Stdio.printerrln("\n**************************************************");
        Stdio.printerrln("************ Solving a problem *******************");
        Stdio.printerrln("**************************************************");
        Stdio.printerrln("*** Check the problem ***");
        if (this.eqn == null) {
            Stdio.printerrln("No equation for this problem !!\n Stop.");
            System.exit(-1);
        }
        if (this.dim != this.eqn.dim()) {
            Stdio.printerrln("Equation and problem have not same dimension !!.\n Stop.");
            System.exit(-1);
        }
        Stdio.printerrln(" --> Equation OK");
        if (this.sch == null) {
            Stdio.printerrln("No time scheme !!\n Stop.");
            System.exit(-1);
        }
        Stdio.printerrln(" --> Scheme : " + this.sch);
        Stdio.printerrln(" --> Initial condition : ");
        int n = 0;
        while (n < this.dim) {
            Stdio.printerrln("\t" + this.cdinit.get(n));
            ++n;
        }
        Stdio.printerrln("*** Problem OK ***\n");
        Stdio.printerrln("*** Memory allocation  ***\n");
        this.inco = new Vector(this.sch.getNstep());
        this.times = new Vector(this.sch.getNstep());
        Stdio.printerrln("*** Time scheme initialisation ***\n");
        this.sch.init();
        this.inco.add(this.sch.present().clone());
        this.times.add(new Double(this.sch.tmin()));
        Stdio.printerrln("*** Starting the resolution ***");
        Chronometer.start();
        n = 1;
        while (this.sch.time() < this.sch.tmax()) {
            this.sch.forward(this.eqn);
            boolean bl = this.sch.update();
            if (bl) {
                this.inco.add((DVect)this.sch.present().clone());
                this.times.add(new Double(this.sch.time()));
            }
            ++n;
        }
        Chronometer.stop();
        Stdio.printerrln("*** elapsed time : " + Chronometer.time() + " ms\n");
        Stdio.printerrln("**********************************************");
        Stdio.printerrln("************ It's the end ! Ciao *************");
        Stdio.printerrln("**********************************************\n");
        this.issolve = true;
    }

    public String printSol() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.issolve) {
            int n = 0;
            while (n < this.times.size()) {
                stringBuffer.append((Double)this.times.get(n) + " ");
                DVect dVect = (DVect)this.inco.get(n);
                int n2 = 0;
                while (n2 < this.dim) {
                    stringBuffer.append(dVect.get(n2) + " ");
                    ++n2;
                }
                stringBuffer.append("\n");
                ++n;
            }
        } else {
            stringBuffer.append("Problem not solved \n");
        }
        return stringBuffer.toString();
    }

    public double[][] toTab() {
        if (this.issolve) {
            double[][] dArray = new double[this.dim + 1][this.times.size()];
            int n = 0;
            while (n < this.times.size()) {
                dArray[0][n] = (Double)this.times.get(n);
                DVect dVect = (DVect)this.inco.get(n);
                int n2 = 1;
                while (n2 <= this.dim) {
                    dArray[n2][n] = dVect.get(n2 - 1);
                    ++n2;
                }
                ++n;
            }
            return dArray;
        }
        return null;
    }

    public double[][] toArray() {
        if (this.issolve) {
            double[][] dArray = new double[this.dim + 1][this.times.size()];
            int n = 0;
            while (n < this.times.size()) {
                dArray[0][n] = (Double)this.times.get(n);
                DVect dVect = (DVect)this.inco.get(n);
                int n2 = 1;
                while (n2 <= this.dim) {
                    dArray[n2][n] = dVect.get(n2 - 1);
                    ++n2;
                }
                ++n;
            }
            return dArray;
        }
        return null;
    }

    public void writeSol(WFile wFile) {
        wFile.writeString(this.printSol());
    }

    public int dim() {
        return this.dim;
    }

    public void setInit(DVect dVect) {
        this.cdinit.set(dVect);
    }

    public DVect getInit() {
        return this.cdinit;
    }

    public int getNStep() {
        if (this.issolve) {
            return this.times.size();
        }
        return -1;
    }

    public void setEqn(Equation equation) {
        if (this.dim != equation.dim()) {
            Stdio.printerrln("Equation and problem have not same dimension !!.\n Stop.");
            System.exit(-1);
        }
        this.eqn = equation;
    }

    public Equation getEqn() {
        return this.eqn;
    }

    public void setTS(TimeScheme timeScheme) {
        this.sch = timeScheme;
        timeScheme.setPb(this);
    }

    public TimeScheme getTS() {
        return this.sch;
    }

    public int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("dim")) {
            int n = streamTokenizer.nextToken();
            if (n != -2) {
                return -1;
            }
            this.dim = (int)streamTokenizer.nval;
            this.cdinit = new DVect(this.dim);
            return 0;
        }
        if (string.equals("y0")) {
            int n = 0;
            while (n < this.dim) {
                int n2 = streamTokenizer.nextToken();
                if (n2 != -2) {
                    return -1;
                }
                this.cdinit.set(n, streamTokenizer.nval);
                ++n;
            }
            return 0;
        }
        if (string.equals("sch")) {
            int n = streamTokenizer.nextToken();
            if (n != -3) {
                throw new InvalidFormatException("Incorrect data file : Error reading a time scheme in a problem");
            }
            if (!opaleSet.contains(streamTokenizer.sval) || opaleSet.getObject(streamTokenizer.sval) == null) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + streamTokenizer.sval + " doesn't exist !!");
            }
            if (!(opaleSet.getObject(streamTokenizer.sval) instanceof TimeScheme)) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + streamTokenizer.sval + " is not a time scheme !!");
            }
            this.setTS((TimeScheme)opaleSet.getObject(streamTokenizer.sval));
            return 0;
        }
        if (string.equals("eqn")) {
            int n = streamTokenizer.nextToken();
            if (n != -3) {
                throw new InvalidFormatException("Incorrect data file : Error reading an equation in a problem");
            }
            if (!opaleSet.contains(streamTokenizer.sval) || opaleSet.getObject(streamTokenizer.sval) == null) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + streamTokenizer.sval + "  doesn't exist!!");
            }
            if (!(opaleSet.getObject(streamTokenizer.sval) instanceof Equation)) {
                throw new InvalidFormatException("Incorrect data file : indentifier  " + streamTokenizer.sval + " isn't an equation !!");
            }
            this.setEqn((Equation)((Object)opaleSet.getObject(streamTokenizer.sval)));
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("{");
        if (!opaleSet.contains(this.sch)) {
            throw new InvalidFormatException("Error writing a file : the time scheme " + this.sch + " doesn't exist !!");
        }
        if (!(this.eqn instanceof ObjectODE)) {
            throw new InvalidFormatException("Error writing a file : the equation " + this.eqn + " of type " + this.eqn.getClass() + " can't print in a file !!");
        }
        if (!opaleSet.contains((ObjectODE)((Object)this.eqn))) {
            throw new InvalidFormatException("Error writing a file : the equation " + this.eqn + " doesn't exist !!");
        }
        printWriter.println("dim " + this.dim);
        printWriter.print("y0");
        int n = 0;
        while (n < this.dim) {
            printWriter.print(" " + this.cdinit.get(n));
            ++n;
        }
        printWriter.println("");
        printWriter.println("sch " + this.sch.getId());
        printWriter.println("eqn " + ((SEquation)this.eqn).getId());
        printWriter.println("}");
    }

    public String toString() {
        return "Problem of ODE";
    }
}

