import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class Jacobi
{
public static void main(String[] arg)
	{
	final int size = 100;
	Matrix A = new Matrix (size,size);
	DVect b = new DVect(size);
	DVect x = new DVect(size);
	
	for (int i=0;i<size;i++)
		{
		A.set(i,i,2);
		if (i>0) A.set(i,i-1,-1);
		if (i<size-1) A.set(i,i+1,-1);
		 }
	b.set(0,1);
	b.set(1,3);
	//System.out.println(A);
	Matrix AA=(Matrix)A.clone();	 
	SolverJacobi jac = new SolverJacobi();
	jac.solve(AA,b,x);

	
	
	DVect err = new DVect(size);
	double tmp;
	for (int i=0;i<size;i++)
		{
		tmp = 0-b.get(i);
		for(int j = 0;j <size;j++)
				tmp +=A.get(i,j)*x.get(j);
		err.set(i,tmp);
		}
	
	System.out.println("Err = "+err.getMax());
	
	}
	
}
