/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import opale.mathtools.DVect;
import opale.tools.Assert;
import opale.tools.InvalidFormatException;

public class DArray
implements Cloneable {
    private DVect tab;
    private int[] dim;
    private int nb_dim;

    public DArray() {
        this.nb_dim = 0;
    }

    public DArray(int n) {
        this.nb_dim = 1;
        this.dim = new int[this.nb_dim];
        this.dim[0] = n;
        this.tab = new DVect(n);
    }

    public DArray(int n, int n2) {
        this.nb_dim = 2;
        this.dim = new int[this.nb_dim];
        this.dim[0] = n;
        this.dim[1] = n2;
        this.tab = new DVect(n * n2);
    }

    public DArray(int n, int n2, int n3) {
        this.nb_dim = 3;
        this.dim = new int[this.nb_dim];
        this.dim[0] = n;
        this.dim[1] = n2;
        this.dim[2] = n3;
        this.tab = new DVect(n * n2 * n3);
    }

    public double get(int n) {
        Assert.check(this.nb_dim == 1);
        Assert.check(n >= 0 && n < this.dim[0]);
        return this.tab.get(n);
    }

    public double get(int n, int n2) {
        Assert.check(this.nb_dim == 2);
        Assert.check(n >= 0 && n < this.dim[0] && n2 >= 0 && n2 < this.dim[1]);
        return this.tab.get(n * this.dim[0] + n2);
    }

    public double get(int n, int n2, int n3) {
        Assert.check(this.nb_dim == 3);
        Assert.check(n >= 0 && n < this.dim[0] && n2 >= 0 && n2 < this.dim[1] && n3 >= 0 && n3 < this.dim[2]);
        return this.tab.get(n * this.dim[0] * this.dim[1] + n2 * this.dim[1] + n3);
    }

    public void readFile(String string, int n) throws FileNotFoundException, IOException, InvalidFormatException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Vector<Double> vector = new Vector<Double>();
        int n2 = 0;
        int n3 = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            ++n2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n4 = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (++n4 != n) continue;
                Double d = new Double(string3);
                vector.addElement(d);
                ++n3;
                bl = true;
                break;
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        if (n3 == 0) {
            throw new InvalidFormatException("The column " + n + " doesn't exist !!!");
        }
        this.nb_dim = 1;
        this.dim = new int[this.nb_dim];
        this.dim[0] = n3;
        this.tab = new DVect(this.dim[0]);
        int n5 = 0;
        while (n5 < n3) {
            this.tab.set(n5, (Double)vector.get(n5));
            ++n5;
        }
    }

    public void readFile(String string, int n, int n2) throws FileNotFoundException, IOException, InvalidFormatException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            ++n3;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n6 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                Double d;
                String string3 = stringTokenizer.nextToken();
                if (++n6 == n) {
                    d = new Double(string3);
                    vector.addElement(d);
                    ++n4;
                    continue;
                }
                if (n6 != n2) continue;
                d = new Double(string3);
                vector2.addElement(d);
                ++n5;
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        if (n4 == 0) {
            throw new InvalidFormatException("The column " + n + " doesn't exist !!!");
        }
        if (n5 == 0) {
            throw new InvalidFormatException("The column " + n2 + " doesn't exist !!!");
        }
        if (n4 != n5) {
            throw new InvalidFormatException("The columns " + n + " and " + n2 + " have not the same dimension !!!");
        }
        this.nb_dim = 2;
        this.dim = new int[this.nb_dim];
        this.dim[1] = 2;
        this.dim[0] = n4;
        this.tab = new DVect(this.dim[0] * this.dim[1]);
        int n7 = 0;
        while (n7 < n4) {
            this.tab.set(2 * n7, (Double)vector.get(n7));
            this.tab.set(2 * n7 + 1, (Double)vector2.get(n7));
            ++n7;
        }
    }

    public String toString() {
        String string = "Dimension = " + this.nb_dim + "\n\t";
        int n = 0;
        while (n < this.nb_dim) {
            string = string + this.dim[n] + " ";
            ++n;
        }
        string = string + "\n" + this.tab.toString();
        return string;
    }

    public Object clone() {
        try {
            DArray dArray = (DArray)super.clone();
            dArray.nb_dim = this.nb_dim;
            dArray.dim = new int[this.nb_dim];
            int n = 0;
            while (n < this.nb_dim) {
                dArray.dim[n] = this.dim[n];
                ++n;
            }
            dArray.tab = new DVect(this.tab);
            return dArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, InvalidFormatException {
        DArray dArray = new DArray();
        dArray.readFile("test.coupe", 4);
        System.out.println(dArray);
        dArray.readFile("test.coupe", 1, 4);
        System.out.println(dArray);
    }
}

