/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix;

import java.io.IOException;
import java.io.PrintWriter;
import opale.mathtools.DVect;
import opale.mathtools.IyFx;
import opale.tools.Assert;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleObject;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public final class Matrix
extends OpaleObject
implements Cloneable {
    private double[][] a;
    private int n;
    private int m;

    public Matrix() {
        this.m = -1;
        this.n = -1;
        this.a = null;
    }

    public Matrix(int n, int n2) {
        this.m = n2;
        this.n = n;
        this.a = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this.n = dArray.length;
        this.m = dArray[0].length;
        this.a = new double[this.n][this.m];
        Debug.print("n = " + this.n);
        Debug.print("m = " + this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                this.a[n][n2] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public int getRowDim() {
        return this.n;
    }

    public int getColumnDim() {
        return this.m;
    }

    public double get(int n, int n2) {
        Assert.check(n < this.n && n2 < this.m);
        return this.a[n][n2];
    }

    public void set(int n, int n2, double d) {
        Assert.check(n < this.n && n2 < this.m);
        this.a[n][n2] = d;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.n, this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                matrix.a[n][n2] = this.a[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public Matrix add(Matrix matrix) {
        Assert.check(this.n == matrix.n && this.m == matrix.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                double[] dArray = this.a[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] + matrix.a[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public DVect mul(DVect dVect) {
        Assert.check(this.m == dVect.size());
        DVect dVect2 = new DVect(this.n);
        int n = 0;
        while (n < this.n) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.m) {
                d += this.a[n][n2] * dVect.get(n2);
                ++n2;
            }
            dVect2.set(n, d);
            ++n;
        }
        return dVect2;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                matrix.a[n][n2] = this.a[n2][n];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public double[][] getInternalArray() {
        return this.a;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.n][this.m];
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                dArray[n][n2] = this.a[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public void appFunc(IyFx iyFx) {
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                this.a[n][n2] = iyFx.val(this.a[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.n * this.m);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                double d = this.a[n][n2];
                stringBuffer.append(d + " ");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        Matrix matrix = (Matrix)super.clone();
        matrix.n = this.n;
        matrix.m = this.m;
        matrix.a = this.getArrayCopy();
        return matrix;
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("dim")) {
            this.n = (int)streamReader.nextDouble();
            this.m = (int)streamReader.nextDouble();
            if (this.n < 1 || this.m < 1) {
                throw new InvalidFormatException("Matrix dimensions must be positive integer values !!!");
            }
            this.a = new double[this.n][this.m];
            return 0;
        }
        if (string.equals("values")) {
            if (this.n < 1 || this.m < 1) {
                throw new InvalidFormatException("No matrix dimensions are defined !!!");
            }
            int n = 0;
            while (n < this.n) {
                int n2 = 0;
                while (n2 < this.m) {
                    this.a[n][n2] = streamReader.nextDouble();
                    ++n2;
                }
                ++n;
            }
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("{");
        printWriter.println("dim " + this.n + " " + this.m);
        printWriter.println("values");
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.m) {
                printWriter.print(this.a[n][n2] + " ");
                ++n2;
            }
            printWriter.println("");
            ++n;
        }
        printWriter.println("}");
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (this.n != matrix.n || this.m != matrix.m) {
                return false;
            }
            boolean bl = true;
            int n = 0;
            while (n < this.n) {
                int n2 = 0;
                while (n2 < this.m) {
                    bl = bl && this.a[n][n2] == matrix.a[n][n2];
                    ++n2;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }
}

