/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.matrix;



import opale.mathtools.DVect;
import opale.matrix.*;

/** 
* This interface must be implemented by classes that define symmetrical decomposition method, for instance LU, Cholesky... A class can be implemented both <code>Solver</code> and <code>Decomposition</code>.
* @author O.C.
* @date 04/2001
*/

public interface SymDecomposition
{
/**
* Set to true to indicate the algorithm modify the input matrix in the method <code>decomp()</code>. It's an experimental attribute and it will be probably depracted. 
*/
public static final boolean REPLACE=false;



/**
* Decompose the matrix A.
*/
public void decomp(SymMatrix A);
}

