/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.component2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import opale.m2d.AffineTransform2D;
import opale.m2d.component2d.RotationTransformEditor;
import opale.m2d.component2d.ScalingTransformEditor;
import opale.m2d.component2d.TranslationTransformEditor;
import opale.swools.MathExprTextField;

public class AffineTransform2DEditor
extends JFrame {
    private AffineTransform2D afft;
    private JButton okButton = new JButton();
    private JButton appButton = new JButton();
    private JButton closeButton = new JButton();
    private JComboBox setButton = new JComboBox();
    private JComboBox concatenateButton = new JComboBox();
    private BorderLayout layoutFond = new BorderLayout();
    private BorderLayout layoutPanneaufond = new BorderLayout();
    private GridLayout layoutOption = new GridLayout(3, 1);
    private JPanel panneauFond = new JPanel();
    private JPanel panneauBouton = new JPanel();
    private JPanel panneauOption = new JPanel();
    private JPanel panneauMatrix = new JPanel();
    private JPanel matrix = new JPanel(new GridLayout(3, 3));
    private MathExprTextField m00 = new MathExprTextField(15);
    private MathExprTextField m01 = new MathExprTextField(15);
    private MathExprTextField m02 = new MathExprTextField(15);
    private MathExprTextField m10 = new MathExprTextField(15);
    private MathExprTextField m11 = new MathExprTextField(15);
    private MathExprTextField m12 = new MathExprTextField(15);
    private JTextField m20 = new JTextField("0", 15);
    private JTextField m21 = new JTextField("0", 15);
    private JTextField m22 = new JTextField("1", 15);

    public AffineTransform2DEditor(AffineTransform2D affineTransform2D) {
        if (affineTransform2D == null) {
            affineTransform2D = new AffineTransform2D();
        }
        this.afft = affineTransform2D;
        try {
            this.oInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void oInit() throws Exception {
        ((Component)this).setSize(new Dimension(750, 150));
        this.setResizable(true);
        this.setTitle("Affine Transform 2D Editor");
        this.getContentPane().setLayout(this.layoutFond);
        this.panneauFond.setLayout(this.layoutPanneaufond);
        this.panneauOption.setLayout(this.layoutOption);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AffineTransform2DEditor.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.appButton.setText("Apply");
        this.appButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AffineTransform2DEditor.this.appButton_actionPerformed(actionEvent);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AffineTransform2DEditor.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.setButton.addItem("Set to identity");
        this.setButton.addItem("Set to translation");
        this.setButton.addItem("Set to rotation");
        this.setButton.addItem("Set to scaling");
        this.concatenateButton.addItem("Translate");
        this.concatenateButton.addItem("Rotate");
        this.concatenateButton.addItem("Scale");
        this.setButton.setEditable(false);
        this.concatenateButton.setEditable(false);
        Delegue delegue = new Delegue(this);
        this.setButton.addActionListener(delegue);
        this.concatenateButton.addActionListener(delegue);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.panneauFond, "Center");
        this.panneauMatrix.add(this.matrix);
        this.matrix.add(this.m00);
        this.matrix.add(this.m01);
        this.matrix.add(this.m02);
        this.matrix.add(this.m10);
        this.matrix.add(this.m11);
        this.matrix.add(this.m12);
        this.matrix.add(this.m20);
        this.matrix.add(this.m21);
        this.matrix.add(this.m22);
        this.m20.setEditable(false);
        this.m21.setEditable(false);
        this.m22.setEditable(false);
        this.panneauFond.add((Component)this.panneauMatrix, "Center");
        this.panneauFond.add((Component)this.panneauBouton, "South");
        this.panneauFond.add((Component)this.panneauOption, "East");
        this.panneauBouton.add((Component)this.okButton, null);
        this.panneauBouton.add((Component)this.appButton, null);
        this.panneauBouton.add((Component)this.closeButton, null);
        JPanel jPanel = new JPanel();
        jPanel.add(this.setButton);
        this.panneauOption.add((Component)jPanel, null);
        jPanel = new JPanel();
        jPanel.add(this.concatenateButton);
        this.panneauOption.add((Component)jPanel, null);
        this.updateField();
    }

    void updateField() {
        this.m00.setText("" + this.afft.getScaleX());
        this.m11.setText("" + this.afft.getScaleY());
        this.m01.setText("" + this.afft.getShearX());
        this.m10.setText("" + this.afft.getShearY());
        this.m02.setText("" + this.afft.getTranslateX());
        this.m12.setText("" + this.afft.getTranslateY());
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void appButton_actionPerformed(ActionEvent actionEvent) {
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public static void main(String[] stringArray) {
        AffineTransform2DEditor affineTransform2DEditor = new AffineTransform2DEditor(null);
        affineTransform2DEditor.show();
    }

    class Delegue
    implements ActionListener {
        private AffineTransform2DEditor ed;

        Delegue(AffineTransform2DEditor affineTransform2DEditor2) {
            this.ed = affineTransform2DEditor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AffineTransform2DEditor.this.setButton) {
                int n = AffineTransform2DEditor.this.setButton.getSelectedIndex();
                switch (n) {
                    case 0: {
                        AffineTransform2DEditor.this.m00.setText("1.");
                        AffineTransform2DEditor.this.m11.setText("1.");
                        AffineTransform2DEditor.this.m01.setText("0.");
                        AffineTransform2DEditor.this.m10.setText("0.");
                        AffineTransform2DEditor.this.m02.setText("0.");
                        AffineTransform2DEditor.this.m12.setText("0.");
                        break;
                    }
                    case 1: {
                        TranslationTransformEditor translationTransformEditor = new TranslationTransformEditor(this.ed, true, AffineTransform2DEditor.this.afft);
                        translationTransformEditor.show();
                        break;
                    }
                    case 2: {
                        RotationTransformEditor rotationTransformEditor = new RotationTransformEditor(this.ed, true, AffineTransform2DEditor.this.afft);
                        rotationTransformEditor.show();
                        break;
                    }
                    case 3: {
                        ScalingTransformEditor scalingTransformEditor = new ScalingTransformEditor(this.ed, true, AffineTransform2DEditor.this.afft);
                        scalingTransformEditor.show();
                    }
                }
            } else if (actionEvent.getSource() == AffineTransform2DEditor.this.concatenateButton) {
                int n = AffineTransform2DEditor.this.concatenateButton.getSelectedIndex();
                switch (n) {
                    case 0: {
                        TranslationTransformEditor translationTransformEditor = new TranslationTransformEditor(this.ed, false, AffineTransform2DEditor.this.afft);
                        translationTransformEditor.show();
                        break;
                    }
                    case 1: {
                        RotationTransformEditor rotationTransformEditor = new RotationTransformEditor(this.ed, false, AffineTransform2DEditor.this.afft);
                        rotationTransformEditor.show();
                        break;
                    }
                    case 2: {
                        ScalingTransformEditor scalingTransformEditor = new ScalingTransformEditor(this.ed, false, AffineTransform2DEditor.this.afft);
                        scalingTransformEditor.show();
                    }
                }
            }
        }
    }
}

