/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

public class Stat {
    private int dim;
    private double[] x;

    public Stat(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
    }

    public Stat(Stat stat) {
        this.dim = stat.dim;
        double[] dArray = new double[stat.dim];
        int n = 0;
        while (n < this.dim) {
            this.x[n] = stat.x[n];
            ++n;
        }
    }

    public Stat(double[] dArray, int n) {
        this.dim = n;
        int n2 = 0;
        while (n2 < this.dim) {
            this.x[n2] = dArray[n2];
            ++n2;
        }
    }

    public double average() {
        double d = 0.0;
        int n = 0;
        while (n < this.dim) {
            d += d + this.x[n];
            ++n;
        }
        return d /= (double)this.dim;
    }

    public double variance() {
        double d = 0.0;
        int n = 0;
        while (n < this.dim) {
            d += Math.pow(this.x[n] - this.average(), 2.0);
            ++n;
        }
        return d /= (double)this.dim;
    }

    public double variance_ech() {
        int n = this.dim;
        double d = (double)(n / (n - 1)) * this.variance();
        return d;
    }

    public double ecartype() {
        double d = Math.sqrt(this.variance());
        return d;
    }

    public double ecartype_ech() {
        double d = Math.sqrt(this.variance_ech());
        return d;
    }

    public double covariance(Stat stat) {
        double d = 0.0;
        int n = 0;
        while (n < stat.dim) {
            d += (this.x[n] - this.average()) * (stat.x[n] - stat.average());
            ++n;
        }
        return d /= (double)stat.dim;
    }

    public double correlation(Stat stat) {
        double d = this.covariance(stat) / (this.ecartype() * stat.ecartype());
        return d;
    }
}

