/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;
import java.awt.Color;
import opale.tools.*;
import java.io.*;


/**
* Cette classe contient les informations obligatoires que doit renseign  toute instance d'une classe implmentant l'interface <codeGObject2D</code>.
Dans cette interface on trouve a cet effet la mthode <code>InfoObjet getInfo()</code> qui doit etre obligatoirement dfinit dans les classes filles.
* Il sera possible, conseill voire indispensable de driver cette classe <code>InfoObjet</code> pour des objets gomtriques ncessitant plus d'informations. 
* @author O.C.
* @since Opale-2d 0.1
*/

public class InfoObject implements Cloneable
{
//les membres privs
private String name;
private Color color;
private boolean visible;

/**
* Le constructeur par dfaut
*/
public InfoObject()
	{
	color = Color.black;
	name = new String("Sans_nom");
	visible = true;
	}

/**
* Le constructeur de copie
* @param InfoObjet, l'instance  copier
*/
public InfoObject(InfoObject inf)
	{
	color = inf.getColor();
	name = new String(inf.getName());
	visible = inf.isVisible();
	}
/**
* Lit dans un flux les donnes relatives aux informations d'un objet graphique en invoquant la mthode
readKeyWord()
* @param StreamReader f, le fichier  lire.
* @prama OpaleSet p, le pack2D qui contient les objets courants.
*/
public void read(StreamReader f,OpaleSet pack) throws java.io.IOException,InvalidFormatException
	{
	int type;

	String sval  = f.next();	//on lit la premiere '{'
	if ( !sval.equals("{") ) throw new InvalidFormatException("Stream of data non valid !!");
	while ( !((sval = f.next()).equals("}")))
		{
		if ((sval).equals("NAME"))
			{
			name = f.next();
			} 
		else if ((sval).equals("COLOR"))
			{
			int r = f.nextInteger();
			int g = f.nextInteger();
			int b =f.nextInteger();
			color = new Color(r,g,b);

			} 
		else if ((sval).equals("VISIBLE"))
			{
			sval = f.next();
			if (sval.equals("YES")) setVisible();
			else if (sval.equals("NO")) setUnvisible();
			else throw new InvalidFormatException("Fichier de donnes au mauvais format : erreur  la lecture de la visibilit d'un objet graphique. On attendait YES ou NO");
			} 
			
		else if (readKeyWord(sval,f,pack) == -1) throw new InvalidFormatException("Data file "+f+" is non valid   : error reading a keyword "+sval+" !!");
		}
	
	}
	
/**
* Interprte un mot cl lu dans un fichier.
* @param String word, le mot cl  dcoder.
* @param StreamReader f, le fichier en cours de lecture.
* @param Pack2D p, le pack qui contient l'ensemble des objets 2d en cours
d'existence.
* @return int, 0 si le mot  t compris, -1 sinon.
*/
public int readKeyWord(String word,StreamReader  f,OpaleSet pack) throws java.io.IOException, InvalidFormatException
	{
	return -1;
	} 

/**
* Ecrit les informations concernant l'objet dans un fichier.
* @param WFile f, le fichier dans lequel il faut crire.
*/
public void write(PrintWriter f,OpaleSet pack)  throws InvalidFormatException
	{
	f.println("INFO");
	f.println("\t{");
	f.println("\tNAME " +name);
	f.println("\tCOLOR " +color.getRed()+" " +color.getGreen()+" "+color.getBlue());
	if (visible==false)
		f.println("\tVISIBLE NO");
	writeMore(f,pack);
	f.println("\t}");
	}

/**
* Ecris les informations complmentaires concernant l'objet dans un fichier.
* @param WFile f, le fichier dans lequel il faut crire.
*/
public void writeMore(PrintWriter f,OpaleSet pack) throws InvalidFormatException {}

//les methodes d'acces publiques

/**
* Renvoie le nom de l'instance
* @return String nom, nom de l'instance
*/
public String getName()
	{
	return name;
	}

/**
* Change le nom de l'instance
* @param String nom, le nouveau nom
*/
public void setName(String nom)
	{
	name = new String(nom);
	}


/**
* Renvoie la couleur de trac
* @return Color, la couleur
*/
public Color getColor()
	{
	return color;
	}

/**
* Change la couleur du trac
* @param Color color, la nouvelle couleur
*/
public void setColor(Color color)
	{
	this.color = color;
	}

/**
* Precise si l'objet est visible ou pas
* @return boolean, true si l'objet est visible, false sinon
*/
public boolean isVisible()
	{
	return visible;
	}

/**
* Rend visible l'objet
*/
public void setVisible()
	{
	visible = true;
	}

/**
* Rend invisible l'objet
*/
public void setUnvisible()
	{
	visible = false;
	}

/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
		{
		return (InfoObject) super.clone();
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
	    throw new InternalError();
		}
    }

}
