/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;

/**
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import opale.swools.*;
import opale.m2d.*;




public class ScalingTransformEditor extends JFrame 
{
private AffineTransform2D afft;
private AffineTransform2DEditor afftEditor;
private boolean set;

private Font font = new Font("Monospaced", 1, 12);
private   JButton okButton = new JButton();
private   JButton appButton = new JButton();
private   JButton closeButton = new JButton();


private   BorderLayout layoutFond = new BorderLayout();
private   BorderLayout layoutPanneaufond = new BorderLayout();
private   GridLayout layoutOption = new GridLayout(2,1);
private   JPanel panneauFond = new JPanel();
private   JPanel panneauBouton = new JPanel();
private   JPanel panneauOption = new JPanel();
private MathExprTextField sx = new MathExprTextField(10);
private MathExprTextField sy = new MathExprTextField(10);
private JLabel labsx = new JLabel("sx");
private JLabel labsy = new JLabel("sy");

public ScalingTransformEditor(boolean set, AffineTransform2D at)
{
super();
this.set = set;
afftEditor = null;
if (at == null)
	at = new AffineTransform2D();
afft = at;
  try {
    oInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }
}


public ScalingTransformEditor(AffineTransform2DEditor ed, boolean set, AffineTransform2D at)
{
super();
afftEditor = ed;
this.set = set;
if (at == null)
	at = new AffineTransform2D();
afft = at;
  try {
    oInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }
}

private void oInit() throws Exception {
  this.setSize(new Dimension(300, 150));
  setResizable(true);
  setTitle("Scaling Transform 2D Editor");
  this.getContentPane().setLayout(layoutFond);
  panneauFond.setLayout(layoutPanneaufond);
  panneauOption.setLayout(layoutOption);
  

// Les boutons ok, apply & close
  okButton.setText("Ok");
  okButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      okButton_actionPerformed(e);
    }
  });
  appButton.setText("Apply");
  appButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      appButton_actionPerformed(e);
    }
  });
  closeButton.setText("Close");
  closeButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      closeButton_actionPerformed(e);
    }
  });
  
  


  this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
  this.getContentPane().add(panneauFond, BorderLayout.CENTER);

  panneauFond.add(panneauBouton, BorderLayout.SOUTH);
  panneauFond.add(panneauOption, BorderLayout.CENTER);


  JPanel tmp = new JPanel();
  labsx.setFont(font);
  tmp.add(labsx);
  tmp.add(sx);
  panneauOption.add(tmp);
  
  tmp = new JPanel();
  labsy.setFont(font);
  tmp.add(labsy);
  tmp.add(sy);
  panneauOption.add(tmp);
  
  
  panneauBouton.add(okButton, null);
  panneauBouton.add(appButton, null);
  panneauBouton.add(closeButton, null);




}


  void okButton_actionPerformed(ActionEvent e) {
  double dx = 0, dy = 0;
  if (sx.isValid())
  	  {
  	  dx = sx.getValue();
  	  }
  if (sy.isValid())
  	  {
  	  dy = sy.getValue();
  	  }
  if (set == true)
  	{
	afft.setToScale(dx,dy);
	}
  else
  	{
	afft.scale(dx,dy);
	}
  if (afftEditor!=null) afftEditor.updateField();
  dispose();
  }

  void appButton_actionPerformed(ActionEvent e) {
  double dx = 0, dy = 0;
  if (sx.isValid())
  	  {
  	  dx = sx.getValue();
  	  }
  if (sy.isValid())
  	  {
  	  dy = sy.getValue();
  	  }
  if (set == true)
  	{
	afft.setToScale(dx,dy);
	}
  else
  	{
	afft.scale(dx,dy);
	}
  if (afftEditor!=null) afftEditor.updateField();
  
  }

  void closeButton_actionPerformed(ActionEvent e) {
 dispose();

  }


}
