/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.tools;




/**
* The class <code>Chronometer</code> permits to measure the time, with millisecond precision.
* @author O.C.
* @date 07/01/2001
* @since Opale-Tools 0.11
*/


public class Chronometer
{
private static long begin,end,time;
/**
* Start the timer.
*/
public static void start()
	{
	time = 0;
	begin = System.currentTimeMillis();
	}
/**
* Stop the timer.
*/
public static void stop()
	{
	end = System.currentTimeMillis();
	time += end-begin;
	}


/**
* Resume the timer, that is stopped by <code>stop()</code>.
*/
public static void resume()
	{
	begin = System.currentTimeMillis();
	}
/**
* Return the elapsed time measured in milliseconds.
* @return  long, the time.
*/
public static long time()
	{
	return time;
	}
	
/**
* Return the elapsed time measured in seconds.
* @return double, the time.
* @since Opale-Tools 0.13
*/
public static double stime()
	{
	return time/1000.;
	}
	
/**
* Return the elapsed time measured in minutes.
* @return double, the time.
* @since Opale-Tools 0.13
*/
public static double mtime()
	{
	return time/60000.;
	}
/**
* Return the elapsed time measured in hours.
* @return double, the time.
* @since Opale-Tools 0.13
*/
public static double htime()
	{
	return time/3600000.;
	}
	
	
public static void main(String[] arg)
	{
	Chronometer.start();
	for (int i = 1;i<1000000;i++)
		{}
	Chronometer.stop();
	Chronometer.resume();
	for (int i = 1;i<1000000;i++)
		{}
	Chronometer.stop();
	System.out.println("ms "+Chronometer.time());
	System.out.println("s "+Chronometer.stime());
	System.out.println("m "+Chronometer.mtime());
	System.out.println("h "+Chronometer.htime());
	}
}


