/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.cst.chemistry.*;
import opale.tools.*;

public class Chemistry
{
public static void main(String[] arg)
	{
	//AllElements all = new AllElements();
	Element oxygen = AllElements.getElement("OxYgen");
	System.out.println(oxygen);
	System.out.println(oxygen.getSymbol());
	System.out.println(oxygen.getZ());
	System.out.println(oxygen.getA());
	System.out.println(AllElements.get("Calcium","A"));


	System.out.println("All elements : ");
	for (int i =0;i<AllElements.getSize();i++)
		System.out.println(AllElements.getElement(i));

	Stdio.println("Type of Field to find ?");
	String field = Stdio.input();
	Stdio.println("Value of this field to find ?");
	String val = Stdio.input();
	Element[] resu = AllElements.search(field,val);
	System.out.println(resu.length+" elements with "+field+" = "+val+" :");
	for (int i =0;i<resu.length;i++) Stdio.println(resu[i].toLongString());

	}
}
