/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;
import opale.m2d.marktype.*;
import opale.tools.*;
import java.io.*;

/**
* This class extends Point2D and implements GObject2D. So it makes it possible to draw a 2d-point with a Pen2D.
* @author O.C.
* @since Opale-2d 0.1
*/

public class GPoint2D extends Point2D implements GObject2D, Cloneable
{
//membres privs
private DefaultGraphicalOptions info; //Info sur le point

/**
* Default constructor.
*/
public GPoint2D()
	{
	super();
	if (Debug.On) Debug.print("Dans GPoint2D()");
	info = new DefaultGraphicalOptions();
	}

/**
* Initializes the point at the origin of a specified OIJ, and with graphical options by default.
* @param OIJ rep.
*/
public GPoint2D(OIJ rep)
	{
	super(rep);
	info = new DefaultGraphicalOptions();
	}

/**
* Constructs a point with specified coordinates and a specified OIJ and with graphical options by default..
* @param OIJ rep
* @param double x, y the coordinates.
*/
public GPoint2D(OIJ rep,double x, double y)
	{
	super(rep,x,y);
	info = new DefaultGraphicalOptions();
	}

/**
* Construit et initialise le point  partir d'un Point2D et avec les informations par dfaut.  
* @param Point2D p le point
*/
public GPoint2D(Point2D p)
	{
	super(p);
	info = new DefaultGraphicalOptions();
	}


/**
* Copy constructor
* @param Point2D, the point to be copied.
*/
public GPoint2D(GPoint2D p)
	{
	super(p);
	info = new DefaultGraphicalOptions((DefaultGraphicalOptions) p.getInfo());
	}


//definition des methodes de l'interface GObject2D

public void draw(Pen2D c)
	{
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		MarkType mt = info.getMarktype();
		mt.draw(c,x,y);
		}	
	}
	


public InfoObject getInfo()
	{
	return info;
	}



/**
* Clones this object.
* @return Object a clone object.
* @exception  OutOfMemoryError if not enough memory.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
		{
		GPoint2D p = (GPoint2D) super.clone();
		p.info = (DefaultGraphicalOptions) info.clone();
		return p;
		}
	catch (InternalError e) // ne devrait jamais arriver
		{
		throw e;
		}
    }

public int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	info.write(f,p);
	super.writeMore(f,p);
	}	


public double x(double t) { return x; }
public double y(double t) {  return y; }


	}

