#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import os, sys

if sys.platform.startswith( "win" ):
	# Fetchs gtk2 path from registry
	import _winreg
	import msvcrt
	try:
		k = _winreg.OpenKey( _winreg.HKEY_LOCAL_MACHINE, "Software\\GTK\\2.0" )
	except EnvironmentError:
		print "You must install the Gtk+ 2.2 Runtime Environment to run this program"
		while not msvcrt.kbhit():
			pass
		sys.exit(1)
	else:    
		gtkdir = _winreg.QueryValueEx( k, "Path" )
		os.environ['PATH'] += ";%s/lib;%s/bin" % ( gtkdir[0], gtkdir[0] )
import pygtk
pygtk.require( "2.0" )
import gobject, gtk, gtk.glade
import locale, gettext
import pango

from values import *
from config import *
from sub import *
from callbacks import *
from fileio import *

class app:
	def __init__( self, config ):
		self.config = config
		### Internationalisation (gettext) :
		locale.setlocale( locale.LC_ALL, "" )
		gettext.bindtextdomain ( self.config.app_name, self.config.locales_dir )
		gettext.textdomain ( self.config.app_name )
		gettext.install( self.config.app_name, self.config.locales_dir, unicode=1 )
		
	# Interface functions :
	def load_glade_interface( self ):
		gtk.glade.bindtextdomain( self.config.app_name, self.config.locales_dir )
		gtk.glade.textdomain( self.config.app_name )
		self.glade = gtk.glade.XML( self.config.glade_file )
		#self.glade.signal_autoconnect( locals() )

		self.create_treeview()

		# as glade needs to create a style (icons, text, both, etc.) and doesn't
		# want to rely on user pref, we need to erase the style.
		# We should have a user pref for theOS : text, icon, both or gtk_pref.
		self.get_widget( "toolbar" ).unset_style()

	def connect_gtk_widgets( self ):
		#sub = self.sub

		self.get_widget( "menu_quit" ).connect( "activate", gtk_main_quit )
		self.get_widget( "topwin" ).connect( "destroy", gtk_main_quit )

		# we do NOT want dialog windows to be destroyed when we close then with WM's close button :
		self.get_widget( "dialog_about" ).connect( "delete_event", cb_widget_delete, self, "dialog_about" )
		self.get_widget( "dialog_retime" ).connect( "delete_event", cb_widget_delete, self, "dialog_retime" )
		self.get_widget( "dialog_styles" ).connect( "delete_event", cb_widget_delete, self, "dialog_styles" )
		self.get_widget( "dialog_properties" ).connect( "delete_event", cb_widget_delete, self, "dialog_properties" )
		
		self.get_widget( "button_new" ).connect( "clicked", on_new_activate, self )
		self.get_widget( "button_open" ).connect( "clicked", on_open_activate, self )
		self.get_widget( "button_close" ).set_sensitive( gtk.FALSE )
		self.get_widget( "button_undo" ).set_sensitive( gtk.FALSE )
		self.get_widget( "button_redo" ).set_sensitive( gtk.FALSE )
		self.get_widget( "button_up" ).set_sensitive( gtk.FALSE )
		self.get_widget( "button_down" ).set_sensitive( gtk.FALSE )
		self.get_widget( "button_add" ).connect( "activate", on_insert_line, self )
		self.get_widget( "button_del" ).connect( "clicked", on_delete_line, self )
		self.get_widget( "button_dup" ).connect( "clicked", on_duplicate_line, self )
		self.get_widget( "button_quit" ).connect( "clicked", gtk_main_quit )
		
		self.get_widget( "menu_close" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_undo" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_redo" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_check_spelling" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_set_lang" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_new" ).connect( "activate", on_new_activate, self )
		self.get_widget( "menu_open" ).connect( "activate", on_open_activate, self )
		self.get_widget( "menu_save" ).connect( "activate", on_save_activate, self )
		self.get_widget( "button_save" ).connect( "clicked", on_save_activate, self )
		self.get_widget( "menu_save_as" ).connect( "activate", on_save_as_activate, self )
		self.get_widget( "menu_export_ass" ).connect( "activate", on_export_ass_activate, self )
		
		self.get_widget( "menu_shift_times" ).connect( "activate", on_retime_activate, self )
		self.get_widget( "retime_cancel" ).connect( "clicked", on_retime_cancel, self )
		self.get_widget( "retime_ok" ).connect( "clicked", on_retime_ok, self )
		self.get_widget( "menu_line_cut" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_line_copy" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_line_paste" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_line_del" ).set_sensitive( gtk.FALSE )
		self.get_widget( "menu_line_ins" ).connect( "activate", on_insert_line, self )
		self.get_widget( "menu_line_dup" ).connect( "activate", on_duplicate_line, self )
		self.get_widget( "menu_endline_lf" ).connect( "activate", on_set_endline, self, LF )
		self.get_widget( "menu_endline_crlf" ).connect( "activate", on_set_endline, self, CR+LF )
		self.get_widget( "menu_prefs" ).set_sensitive( gtk.FALSE )

		self.get_widget( "menu_about" ).connect( "activate", cb_widget_show, self, "dialog_about" )
		self.get_widget( "close_about" ).connect( "clicked", cb_widget_hide, self, "dialog_about" )
		self.get_widget( "menu_edit_styles" ).connect( "activate", cb_widget_show, self, "dialog_styles" )
		self.get_widget( "menu_edit_props" ).connect( "activate", cb_widget_show, self, "dialog_properties" )
		self.get_widget( "dialog_styles_close" ).connect( "clicked", cb_widget_hide, self, "dialog_styles" )
		self.get_widget( "dialog_properties_close" ).connect( "clicked", cb_widget_hide, self, "dialog_properties" )
		
		self.get_widget( "combo_name" ).disable_activate()
		self.get_widget( "combo_name" ).set_use_arrows( gtk.TRUE )
		self.get_widget( "combo_style" ).disable_activate()
		self.get_widget( "combo_style" ).set_use_arrows( gtk.TRUE )
		
#		self.get_widget( "name" ).connect( "changed", on_combo_changed, SSA_COL_Name, self )
#		self.get_widget( "style" ).connect( "changed", on_combo_changed, SSA_COL_Style, self )
		self.get_widget( "name" ).connect( "key-press-event", on_sub_changed, SSA_COL_Name, self )
		self.get_widget( "style" ).connect( "key-press-event", on_sub_changed, SSA_COL_Style, self )
		
		self.get_widget( "start" ).connect( "changed", on_time_change, self )
		self.get_widget( "end" ).connect( "changed", on_time_change, self )
		self.get_widget( "start" ).connect( "key-press-event", on_sub_changed, SSA_COL_Start, self )
		self.get_widget( "end" ).connect( "key-press-event", on_sub_changed, SSA_COL_End, self )
		
		self.get_widget( "marginl" ).connect( "key-press-event", on_sub_changed, SSA_COL_MarginL, self )
		self.get_widget( "marginr" ).connect( "key-press-event", on_sub_changed, SSA_COL_MarginR, self )
		self.get_widget( "marginv" ).connect( "key-press-event", on_sub_changed, SSA_COL_MarginV,  self )
		self.get_widget( "subtitle" ).connect( "key-press-event", on_sub_changed, SSA_COL_Subtitle, self )
		self.get_widget( "comment_but" ).connect( "pressed", on_comment_toggle, self )
		
		self.get_widget( "events" ).get_selection().connect( "changed", on_list_selected_row, self )

	# connect_gtk_widgets( self )



	def tree_insert_after_row( self, parent, args ):
		model = self.events_model
		try: args[12] = pango.STYLE_NORMAL
		except: args.append( pango.STYLE_NORMAL )
		try: args[13] = self.config.colors.bg
		except: args.append( self.config.colors.bg )
		try: args[14] = self.config.colors.fg
		except: args.append( self.config.colors.fg )
		myiter = model.insert_after( parent, self.sub.selected_row, args )

	def tree_insert_before_row( self, parent, args ):
		model = self.events_model
		try: args[12] = pango.STYLE_NORMAL
		except: args.append( pango.STYLE_NORMAL )
		try: args[13] = self.config.colors.bg
		except: args.append( self.config.colors.bg )
		try: args[14] = self.config.colors.fg
		except: args.append( self.config.colors.fg )
		myiter = model.insert_before( parent, self.sub.selected_row, args )

	def tree_append_row( self, parent, args ):
		model = self.events_model
		try: args[12] = pango.STYLE_NORMAL
		except: args.append( pango.STYLE_NORMAL )
		try: args[13] = self.config.colors.bg
		except: args.append( self.config.colors.bg )
		try: args[14] = self.config.colors.fg
		except: args.append( self.config.colors.fg )
		myiter = model.append( parent, args )
		return myiter

	def tree_get_row( self, iter ):
		model = self.events_model
		index = 0
		event = []
		while index < model.get_n_columns():
			event.append( model.get_value( iter, index ) )
			index += 1
		return event

	def renumber_tree( self, iter ):
		model = self.events_model
		if iter == None:
			iter = model.get_iter_first()
			index = 1
		else:
			index = string.atoi( model.get_value( iter, 0 ) )
		while iter != None:
			model.set_value( iter, SSA_COL_Number, "%03d" % index )
			iter = model.iter_next( iter )
			index += 1
		return
	# renumber_tree()

	def tree_set_colors( self ):
		model = self.events_model
		treeview = self.get_widget( "events" )
		iter = model.get_iter_first()
		
#		index = 0
		while iter != None:
			event = self.tree_get_row( iter )
			
			if event[SSA_COL_Flag] == "Comment":
				model.set_value( iter, SSA_COL_PangoStyle, pango.STYLE_OBLIQUE )
				model.set_value( iter, SSA_COL_Bg, self.config.colors.bg_com )
			elif ( event[SSA_COL_Start] == event[SSA_COL_End] ) and ( event[SSA_COL_Flag] == "Dialogue" ):
				model.set_value( iter, SSA_COL_Fg, self.config.colors.fg_notime )
#			if iter == self.sub.selected_row:
#				model.set_value( iter, SSA_COL_Fg, "#00ff00" )
			iter = model.iter_next( iter )
#			index += 1
		return
	# tree_set_colors()
	
	def create_treeview( self ):
		treeview = self.get_widget( "events" )
		self.events_model = gtk.TreeStore(
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_INT,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING
			)
		treeview.set_model( self.events_model )
		treeview.set_headers_visible( gtk.TRUE )

		# [ "Title", resizable?, Visible?, index ]
		def_columns = (
			( "", gtk.TRUE, gtk.TRUE, SSA_COL_Number ),
			( "Flag", gtk.TRUE, gtk.TRUE, SSA_COL_Flag ),
			( "Marked", gtk.FALSE, gtk.FALSE, SSA_COL_Marked ),
			( "Start", gtk.TRUE, gtk.TRUE, SSA_COL_Start ),
			( "End", gtk.TRUE, gtk.TRUE, SSA_COL_End ),
			( "Style", gtk.TRUE, gtk.TRUE, SSA_COL_Style ),
			( "Name", gtk.TRUE, gtk.TRUE, SSA_COL_Name ),
			( "MarginL", gtk.FALSE, gtk.FALSE, SSA_COL_MarginL ),
			( "MarginR", gtk.FALSE, gtk.FALSE, SSA_COL_MarginR ),
			( "MarginV", gtk.FALSE, gtk.FALSE, SSA_COL_MarginV ),
			( "Effect", gtk.FALSE, gtk.FALSE, SSA_COL_Effect ),
			( "Subtitle", gtk.TRUE, gtk.TRUE, SSA_COL_Subtitle ) )
		
		for col in def_columns:
			renderer = gtk.CellRendererText()
			column = gtk.TreeViewColumn( col[0], renderer, text=col[3], \
				style=SSA_COL_PangoStyle, background=SSA_COL_Bg, foreground=SSA_COL_Fg )
			column.set_resizable( col[1] )
			column.set_visible( col[2] )
			treeview.append_column( column )
		# for
		
		treeview.show()
		return
	# create_treeview( self )

	def get_widget( self, widget_name ):
		return self.glade.get_widget( widget_name )

	def set_status( self, status_txt ):
		status = self.get_widget( "status" )
		status.pop( 0 )
		status.push( 0, status_txt )
		# Add a timeout status.pop() to auto-clean the status bar after ~10s.

	def load_sub( self, filename ):
		self.sub = sub( filename )
		load_script( self )
		self.tree_set_colors();
		return

	def new_sub( self ):
		self.sub = sub( "" )
		on_new_activate( self, self )
		self.tree_set_colors();
		return


	### FIXME : to implement !!
	### FIXME : should be moved to code/config.py 
	def load_config( self ):
		print "app.load_config()"
