#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import string, re
import gettext
import pango

from values import *
from sub import *
from time import *


# TODO !
def on_paste_activate( *args ):
	print "on_paste_activate"
def on_cut_activate( *args ):
	print "on_cut_activate"
def on_clear_activate( *args ):
	print "on_clear_activate"
def on_copy_activate( *args ):
	print "on_copy_activate"


def gtk_main_quit( *args ):
	gtk.main_quit()
def on_quit_activate( *args ):
	gtk_main_quit()


def on_list_selected_row( self, app ):
	model, iter = self.get_selected()
	if iter != None:
		event = app.tree_get_row( iter )
		
		app.get_widget( "start" ).set_text( event[SSA_COL_Start] )
		app.get_widget( "end" ).set_text( event[SSA_COL_End] )
		app.get_widget( "style" ).set_text( event[SSA_COL_Style] )
		app.get_widget( "name" ).set_text( event[SSA_COL_Name] )
		app.get_widget( "marginl" ).set_text( event[SSA_COL_MarginL] )
		app.get_widget( "marginr" ).set_text( event[SSA_COL_MarginR] )
		app.get_widget( "marginv" ).set_text( event[SSA_COL_MarginV] )
		app.get_widget( "subtitle" ).set_text( event[SSA_COL_Subtitle] )
		
		if event[SSA_COL_Flag] == "Comment":
			app.get_widget( "comment_but" ).set_active( gtk.TRUE )
		else:
			app.get_widget( "comment_but" ).set_active( gtk.FALSE )
		
		## FIXME : Should it be better if i used a "try" statement ?
		if app.sub.selected_row:
			model.set_value( app.sub.selected_row, 14, app.config.colors.fg )
		model.set_value( iter, 14, "#ff8000" )
		app.sub.selected_row = iter
	# if
	return

def on_insert_line( self, app ):
	app.tree_insert_after_row( None, app.sub.empty_event )
	app.renumber_tree( None )
	return

def on_duplicate_line( self, app ):
	event = app.tree_get_row( app.sub.selected_row )
	app.tree_insert_after_row( None, event )
	app.renumber_tree( None )
	return

def on_delete_line( self, app ):
	model = app.events_model
	del_iter = app.sub.selected_row
	next_iter = model.iter_next( del_iter )

	if next_iter != None:
		app.get_widget( "events" ).get_selection().select_iter( next_iter )
		app.get_widget( "events" ).grab_focus()
		on_list_selected_row( app.get_widget( "events" ).get_selection(), app )

	model.remove( del_iter )
	app.sub.nb_rows -= 1
	app.renumber_tree( None )
	return


def on_combo_changed( self, SSA_COL, app ):
	if ( SSA_COL == SSA_COL_Style ) or ( SSA_COL == SSA_COL_Name ):
		model.set_value( sub.selected_row, SSA_COL+1, self.get_text() )
	return


def on_sub_changed( self, gdk_key_event, SSA_COL, app ):
	sub = app.sub
	events = app.get_widget( "events" )
	model = app.events_model
	iter = sub.selected_row

	# On a <ctrl+enter> event : We should update EVERY fields, and go to the next line.
	if ( gdk_key_event.state == 20 ) and \
			( ( gdk_key_event.keyval == gtk.keysyms.Return ) or \
			( gdk_key_event.keyval == gtk.keysyms.KP_Enter ) ):
		model.set_value( iter, SSA_COL_Start, app.get_widget( "start" ).get_text() )
		model.set_value( iter, SSA_COL_End, app.get_widget( "end" ).get_text() )
		model.set_value( iter, SSA_COL_Style, app.get_widget( "style" ).get_text() )
		model.set_value( iter, SSA_COL_Name, app.get_widget( "name" ).get_text() )
		model.set_value( iter, SSA_COL_MarginL, app.get_widget( "marginl" ).get_text() )
		model.set_value( iter, SSA_COL_MarginR, app.get_widget( "marginr" ).get_text() )
		model.set_value( iter, SSA_COL_MarginV, app.get_widget( "marginv" ).get_text() )
		model.set_value( iter, SSA_COL_Subtitle, app.get_widget( "subtitle" ).get_text() )
		
		if app.get_widget( "comment_but" ).get_active():
			model.set_value( iter, SSA_COL_Flag, "Comment" )
		else:
			model.set_value( iter, SSA_COL_Flag, "Dialogue" )
		
		next_iter = model.iter_next( iter )
		if not next_iter:
			next_iter = app.tree_append_row( None, sub.empty_event )
		app.get_widget( "events" ).get_selection().select_iter( next_iter )
		on_list_selected_row( app.get_widget( "events" ).get_selection(), app )
		app.get_widget( "subtitle" ).grab_focus()
		
	# On an <enter> event : it updates the self field and should do some little things.
	elif ( gdk_key_event.keyval == gtk.keysyms.Return ) or \
			( gdk_key_event.keyval == gtk.keysyms.KP_Enter ):
		
		model.set_value( iter, SSA_COL, self.get_text() )
		
		if ( SSA_COL == SSA_COL_Name ):
			s_name = self.get_text()
			if not sub.names.has_key( s_name ):
				sub.names[s_name] = 1
				sub.set_names( app )
				self.set_text( s_name )
		
		elif ( SSA_COL == SSA_COL_Style ):
			s_style = self.get_text()
			if not sub.styles.has_key( s_style ):
				sub.styles[s_style] = sub.empty_style
				sub.set_styles( app )
				self.set_text( s_style )
	
	return


def on_comment_toggle( self, app ):
	sub = app.sub
	events = app.get_widget( "events" )
	
	if app.events_model.get_value( sub.selected_row, SSA_COL_Flag ) == "Dialogue":
		app.events_model.set_value( sub.selected_row, SSA_COL_Flag, "Comment" )
		app.events_model.set_value( sub.selected_row, SSA_COL_PangoStyle, pango.STYLE_OBLIQUE )
		app.events_model.set_value( sub.selected_row, SSA_COL_Bg, app.config.colors.bg_com )
	else:
		app.events_model.set_value( sub.selected_row, SSA_COL_Flag, "Dialogue" )
		app.events_model.set_value( sub.selected_row, SSA_COL_PangoStyle, pango.STYLE_NORMAL )
		app.events_model.set_value( sub.selected_row, SSA_COL_Bg, app.config.colors.bg )
	return
# on_comment_toggle()


def on_time_change( self, app ):
	start = time( app.get_widget( "start" ).get_text() )
	end = time( app.get_widget( "end" ).get_text() )
	duration = end - start
	app.get_widget( "duration" ).set_text( "%s" % duration )
	return
# def on_time_change()

def on_retime_activate( self, app ):
	app.set_status( _("Enter a shifting time value...") )
	app.get_widget( "dialog_retime" ).show()
	return

def on_retime_cancel( self, app ):
	app.set_status( _("Shift times canceled.") )
	app.get_widget( "dialog_retime" ).hide()
	return

def on_retime_ok( self, app ):
	model = app.events_model
	app.set_status( _("Shifting times...") )
	app.get_widget( "dialog_retime" ).hide()
	shift = time ( app.get_widget( "shift_time" ).get_text() )
	
	if not app.sub.selected_row:
		iter = model.get_iter_first()
	else:
		iter = app.sub.selected_row
	
	while iter != None:
		row = app.tree_get_row( iter )
		start = time( row[SSA_COL_Start] )
		end = time( row[SSA_COL_End] )
		
		if app.get_widget( "shift_forwards" ).get_active():
			if app.get_widget( "shift_se" ).get_active() or app.get_widget( "shift_s" ).get_active():
				start += shift
			if app.get_widget( "shift_se" ).get_active() or app.get_widget( "shift_e" ).get_active():
				end += shift
		elif app.get_widget( "shift_backwards" ).get_active():
			if app.get_widget( "shift_se" ).get_active() or app.get_widget( "shift_s" ).get_active():
				start -= shift
			if app.get_widget( "shift_se" ).get_active() or app.get_widget( "shift_e" ).get_active():
				end -= shift
		# if
		model.set_value( iter, SSA_COL_Start, "%s" % start )
		model.set_value( iter, SSA_COL_End, "%s" % end )
		iter = model.iter_next( iter )

	app.set_status( _("Shift times finished.") )
	return
# def on_retime_ok




def on_set_endline( self, app, endline ):
	if not self.active: return
	app.config.set_endline( endline )
	return

def cb_widget_show( self, app, widget_name ):
	app.get_widget( widget_name ).show()
	return gtk.TRUE

def cb_widget_hide( self, app, widget_name ):
	app.get_widget( widget_name ).hide()
	return gtk.TRUE

def cb_widget_hideshow( self, app, widget_name ):
	if ( self.active ):
		app.get_widget( widget_name ).show()
	else :
		app.get_widget( widget_name ).hide()
	return gtk.TRUE

def cb_widget_delete( self, garbage, app, widget_name ):
	app.get_widget( widget_name ).hide()
	return gtk.TRUE



