#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import os, sys
if sys.platform.startswith( "win" ):
	# Fetchs gtk2 path from registry
	import _winreg
	import msvcrt
	try:
		k = _winreg.OpenKey( _winreg.HKEY_LOCAL_MACHINE, "Software\\GTK\\2.0" )
	except EnvironmentError:
		print "You must install the Gtk+ 2.2 Runtime Environment to run this program"
		while not msvcrt.kbhit():
			pass
		sys.exit(1)
	else:
		gtkdir = _winreg.QueryValueEx( k, "Path" )
		os.environ['PATH'] += ";%s/lib;%s/bin" % ( gtkdir[0], gtkdir[0] )
import pygtk
pygtk.require( "2.0" )
import gtk
import fileinput, locale
import string, re
from values import *
from callbacks import *


class sub:

	### subtitle = sub( "filename.ssa" )
	def __init__( self, filename ):
		if filename != "":
			# FIXME : Should popup a dialog window :
			if not os.path.exists( filename ):
				error_msg = "Error, file not found : '%s' " \
					% os.path.basename( filename )
				sys.exit( error_msg )
			self.filename = filename
		else:
			self.filename = ""
		
		self.selected_row = None
		self.last_iter = None
		self.first_iter = None
		self.nb_rows = 0
		self.empty_event = [ "Dialogue", 0, "0:00:00.00", "0:00:00.00", unicode( "Default", "utf-8" ),
			unicode( "~", "utf-8" ), "0000", "0000", "0000", "", unicode( "", "utf-8" ), "000" ]
		self.empty_style = [ "Default","Arial","28","&H00c1fff9","&H00ffffff","&H00000008","&H80000008", \
			"-1","0","0","0","100","100","0","0.00","1","1","1","2","10","10","10","0" ]
	def get_filename( self ):
		return self.filename
	def set_filename( self, filename ):
		self.filename = filename


	### Sets the NAMES into the appropriate Combo :
	def set_names( self, app ):
		names = self.names.keys()
		names.sort()
		app.get_widget( "combo_name" ).set_popdown_strings( names )

	### Sets the STYLES into the appropriate Combo :
	def set_styles( self, app ):
		styles = self.styles.keys()
		styles.sort() 
		app.get_widget( "combo_style" ).set_popdown_strings( styles )



##################################### 



	### Loads the SUB to internal (SSA) format
	# FIXME : we don't take care about the original file enc...
	def load( self, app ):
		print "Loading SSA file : %s" % self.filename
		self.infos = {}
		self.styles = {}
		self.events = []
		self.names = { "~":1 }
		file_enc = locale.getlocale()[1]
		gtk_enc = "utf-8"

		flag = 0
		row = 0
		pattern1 = re.compile( "^\[" )
		pattern2 = re.compile( \
			"^(\w+): Marked=(\d),([\d:\.]{10}),([\d:\.]{10}),([^,]*),([^,]*),(\d{4}),(\d{4}),(\d{4}),([^,]*),(.*)" )
		pattern3 = re.compile( "^;" )
		
		for line in fileinput.input( self.filename ):
			line = line.strip()
			
			if ( pattern3.search( line ) ) or ( line == "" ):
				continue
			if pattern1.search( line ):
				if line == "[Script Info]":
					flag = 1
				elif line == "[V4 Styles]":
					flag = 2
				elif line == "[Events]":
					flag = 3
					if not self.styles.has_key( "Default" ):
						self.styles["Default"] = self.empty_style 
				continue
			
			if flag == 1:
				( left, right ) = line.split( ":", 1 )
				right = right.replace( " ", "", 1 )
				self.infos[left] = right
				print "Info: [%s:%s]" % ( left, right )
				continue
			
			if flag == 2:
				if ( not re.match( "^Format:", line ) ) and re.search( "^Style:", line ):
					line = string.replace( line, "Style: ", "" )
					this_style = re.split( ",", line )
					tmp = []
					index = 0
					for e in this_style:
						if index == 9:
							tmp.append( "0" )
							tmp.append( "0" )
							tmp.append( "100" )
							tmp.append( "100" )
							tmp.append( "0" )
							tmp.append( "0.00" )
							index = 15
						if index != 22:
							tmp.append( e )
						index += 1
					self.styles[tmp[0]] = tmp
				continue
				
			if flag == 3:
				this_event = pattern2.search( line )
				if this_event != None:
					tmp = []
					index = 0
					sub_enc = file_enc
					
					for e in this_event.groups():
						
						if index == SSA_COL_Style:
							e = string.replace( e, "*", "" )
							if not self.styles.has_key( e ):
								print "Style %s not found, replaced by 'Default'" % e
								e = "Default"
							if self.styles[e][SSA_STYLE_COL_Encoding] == "0":
								sub_enc = file_enc
							elif self.styles[e][SSA_STYLE_COL_Encoding] == "128":
								sub_enc = "shift-jis"
						
						if	( index == SSA_COL_Name ) or ( index == SSA_COL_Style ):
							e = unicode( e, file_enc ).encode( gtk_enc )
						if index == SSA_COL_Subtitle:
							e = unicode( e, sub_enc ).encode( gtk_enc )
						if index == SSA_COL_Name:
							if not self.names.has_key( e ): self.names[e] = 1
						
						tmp.append( e )
						index += 1
					# for
					row += 1
					tmp.append( "%03d" % row )
					app.tree_append_row( None, tmp )
				# if
#				continue
			#if
		#for
		self.nb_rows = row
		fileinput.close()
	# load()


	### Loads an ASS script :
	# FIXME : we don't take care about the original file_enc...
	def load_ass( self, app ):
		self.infos =  {}
		self.styles = {}
		self.events = []
		self.names = { "~":1 }
		file_enc = locale.getlocale()[1]
		gtk_enc = "utf-8"

		flag = 0
		row = 0
		pattern1 = re.compile( "^\[" )
		pattern2 = re.compile( \
			"^(\w+): (\d),([\d:\.]{10}),([\d:\.]{10}),([^,]*),([^,]*),(\d{4}),(\d{4}),(\d{4}),([^,]*),(.*)" )
		pattern3 = re.compile( "^;" )

		for line in fileinput.input( self.filename ):
			line = line.strip()
			
			if pattern3.search( line ) or ( line == "" ):
				continue
				
			if pattern1.search( line ):
				if line == "[Script Info]":
					flag = 1
				elif line == "[V4+ Styles]":
					flag = 2
				elif line == "[Events]":
					flag = 3
					if not self.styles.has_key( "Default" ):
						self.styles["Default"] = self.empty_style 
				continue
			
			if flag == 1:
				( left, right ) = line.split( ":", 1 )
				right = right.replace( " ", "", 1 )
				self.infos[left] = right
				continue
			
			if flag == 2:
				if ( not re.search( "^Format:", line ) ) and re.search( "^Style:", line ):
					line = string.replace( line, "Style: ", "" )
					this_style = re.split( ",", line )
					tmp = []
					for e in this_style:
						tmp.append( e )
					self.styles[tmp[0]] = tmp
				continue
				
			if flag == 3:
				this_event = pattern2.search( line )
				if ( this_event != None ):
					tmp = []
					index = 0
					sub_enc = file_enc
					
					for e in this_event.groups():
						
						if index == SSA_COL_Style:
							e = string.replace( e, "*", "" )
							if not self.styles.has_key( e ):
								print "Style %s not found, replaced by 'Default'" % e
								e = "Default"
							if file_enc != "utf-8":
								if self.styles[e][SSA_STYLE_COL_Encoding] == "0":
									sub_enc = file_enc
								elif self.styles[e][SSA_STYLE_COL_Encoding] == "128":
									sub_enc = "shift-jis"
						
						if file_enc != "utf-8":
							if	( index == SSA_COL_Name ) or ( index == SSA_COL_Style ):
								e = unicode( e, file_enc ).encode( gtk_enc )
							if index == SSA_COL_Subtitle:
								e = unicode( e, sub_enc ).encode( gtk_enc )
						
						if index == SSA_COL_Name:
							if not self.names.has_key( e ): self.names[e] = 1
						
						tmp.append( e )
						index += 1
					# for
					row += 1
					tmp.append( "%03d" % row ) # adding the number of the line to the event (see gtkmodel). FIXME: should be in app.tree_append_row ?
					app.tree_append_row( None, tmp )
				# if
#				continue
			#if
		#for
		self.nb_rows = row
		fileinput.close()
	# load_ass()

	##
	## Loads a .MPSUB file :
	##
	def load_mpsub( self, app ):
		self.infos =  {}
		self.styles = {}
		self.events = []
		self.names = { "~":1 }
		file_enc = locale.getlocale()[1]
		gtk_enc = "utf-8"
		
		framerate = 29.97
		start = 0
		end = 0
		str = ""
		
		flag = 0
		row = 0
		pattern1 = re.compile( "^FORMAT=" )
		pattern2 = re.compile( "^;|^#" )

		for line in fileinput.input( self.filename ):
			line = line.strip()
			
			if pattern2.search( line ):
				continue
			
			if pattern1.search( line ):
				trash, value = line.split( "=", 1 )
				framerate = string.atof( value )
				continue
			
			if re.match( "^([0-9]*) ([0-9]*)$", line ):
				f_start, f_end = line.split( " ", 1 )
				f_start = string.atoi( f_start )
				f_end = string.atoi( f_end )
				start = end + f_start
				end = start + f_end
				continue
			
			if line == "":
				if ( start == 0 ) and ( end == 0 ): continue
				
				s_start = start / framerate
				s_end = end / framerate
				
				s_h = int( s_start / 3600 )
				s_m = int( ( s_start - ( s_h * 3600 ) ) / 60 )
				s_s = int( ( s_start - ( s_h * 3600 ) - ( s_m * 60 ) ) )
				s_r = int ( ( s_start - int( s_start ) ) * 100 )

				e_h = int( s_end / 3600 )
				e_m = int( ( s_end - ( s_h * 3600 ) ) / 60 )
				e_s = int( ( s_end - ( s_h * 3600 ) - ( s_m * 60 ) ) )
				e_r = int ( ( s_end - int( s_end ) ) * 100 )

				str_s = "%01d:%02d:%02d.%02d" % ( s_h, s_m, s_s, s_r )
				str_e = "%01d:%02d:%02d.%02d" % ( e_h, e_m, e_s, e_r )
				
				str = unicode( str, file_enc ).encode( gtk_enc )
				row += 1
				event = [ "Dialogue", 0, str_s, str_e, unicode( "Default", gtk_enc ), unicode( "~", gtk_enc ), "0000", "0000", "0000", "", str, "000" ]
				app.tree_append_row( None, event )
				str = ""
				continue
				
			if str == "": str = line
			else: str = "%s\\n%s" % ( str, line )
			
			self.filename = ""
			self.styles["Default"] = self.empty_style 
		# for
	# load_sub()




	### Saves the SUB to SSA format (default)
	# Why is there 3 types of encoding ( gtk_enc, file_enc & sub_enc ? )
	#		SSA supports multiple encoding files, eg: iso-8859-15 & shift-jis & ...
	#		only subtitles are encoded to special charset so we use sub_enc for it.
	#		file_enc contains the general locale used by the system, and so : the file locale.
	#		gtk_enc is because GTK+ uses utf-8 as its internal locale (for the moment). 
	# In facts : gtk_enc & file_enc should be saved in app.config.enc_gtk & app.config.enc_locale 
	def save( self, app ):
		endline = app.config.get_endline()
		f_ssa = file( self.filename, "w-" )
		f_ssa.write( "[Script Info]" + endline )
		f_ssa.write( "; This is a Sub Station Alpha v4 script." +endline )
		f_ssa.write( "; It was created by the Orange Slice." +endline )
		f_ssa.write( "; For infos and downloads, go to :" +endline )
		f_ssa.write( "; http://www.nongnu.org/orange-slice/" +endline )
		
		infos_txt = [ \
			"Title", \
			"Original Script", \
			"Original Translation", \
			"Original Editing", \
			"Original Timing", \
			"Original Script Checking", \
			"Script Updated By", \
			"Update Details", \
			"Synch Point", \
			"ScriptType", \
			"Collisions", \
			"PlayResX", \
			"PlayResY", \
			"PlayDepth", \
			"Timer", \
			"WrapStyle" ]

		for txt in infos_txt:
			if txt == "ScriptType":
				self.infos[txt] = "v4.00"
			if self.infos.has_key( txt ):
				f_ssa.write( "%s: %s" % ( txt, self.infos[txt] ) + endline )

		f_ssa.write( endline + "[V4 Styles]" + endline )
		f_ssa.write( "Format: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, TertiaryColour, BackColour, Bold, Italic, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, AlphaLevel, Encoding" + endline )

		for style_name in self.styles.keys():
			f_ssa.write( "Style: %s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s%s" % ( \
				style_name, \
				self.styles[style_name][SSA_STYLE_COL_Fontname], \
				self.styles[style_name][SSA_STYLE_COL_Fontsize], \
				self.styles[style_name][SSA_STYLE_COL_PrimaryColour], \
				self.styles[style_name][SSA_STYLE_COL_SecondaryColour], \
				self.styles[style_name][SSA_STYLE_COL_TertiaryColour], \
				self.styles[style_name][SSA_STYLE_COL_BackColour], \
				self.styles[style_name][SSA_STYLE_COL_Bold], \
				self.styles[style_name][SSA_STYLE_COL_Italic], \
				self.styles[style_name][SSA_STYLE_COL_BorderStyle], \
				self.styles[style_name][SSA_STYLE_COL_Outline], \
				self.styles[style_name][SSA_STYLE_COL_Shadow], \
				self.styles[style_name][SSA_STYLE_COL_Alignment], \
				self.styles[style_name][SSA_STYLE_COL_MarginL], \
				self.styles[style_name][SSA_STYLE_COL_MarginR], \
				self.styles[style_name][SSA_STYLE_COL_MarginV], \
				0, \
				self.styles[style_name][SSA_STYLE_COL_Encoding], \
				endline ) )
		f_ssa.write( endline + "[Events]" + endline )
		f_ssa.write( "Format: Marked, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text" + endline )
		
		model = app.events_model
		iter = model.get_iter_root()
		file_enc = locale.getlocale()[1]
		while iter != None:
			entry = app.tree_get_row( iter )
			iter = model.iter_next( iter )
			
			sub_enc = file_enc
			gtk_enc = "utf-8"
			if self.styles[entry[SSA_COL_Style]][SSA_STYLE_COL_Encoding] == "128":
				sub_enc = "shift-jis"
			# FIXME : shift-jis encoding seems to be broken
			#		not an Orange Slice pb i think, since iso-8859-15 is working very well.
			#print "Saving: %s (%s)" % ( entry[SSA_COL_Subtitle], sub_enc )
			f_ssa.write("%s: Marked=%s,%s,%s,%s,%s,%s,%s,%s,%s,%s%s" % (
				entry[SSA_COL_Flag], \
				entry[SSA_COL_Marked], \
				entry[SSA_COL_Start], \
				entry[SSA_COL_End], \
				entry[SSA_COL_Style].encode( file_enc ), \
				entry[SSA_COL_Name].encode( file_enc ), \
				entry[SSA_COL_MarginL], \
				entry[SSA_COL_MarginR], \
				entry[SSA_COL_MarginV], \
				entry[SSA_COL_Effect	], \
				entry[SSA_COL_Subtitle].encode( sub_enc ), \
				endline ) )
		f_ssa.write( endline )
	# save()

	### Saves the SUB to ASS format
	def save_ass( self, app ):
		endline = app.config.get_endline()
		filename_export = re.compile( "\.ssa$" ).sub( ".ass", self.filename )
		f_ass = file( filename_export, "w-" )
		f_ass.write( "[Script Info]" + endline )
		f_ass.write( "; This is an Advanced Sub Station Alpha v4+ script." + endline + ";" + endline )
		f_ass.write( "; Advanced Sub Station Alpha script format developed by #Anime-Fansubs@EfNET" + endline )
		f_ass.write( "; http://www.anime-fansubs.org" + endline + ";" + endline )
		f_ass.write( "; This file was saved by the Orange Slice." + endline )
		f_ass.write( "; For infos and downloads, go to" + endline )
		f_ass.write( "; http://www.nongnu.org/orange-slice/" + endline + ";" + endline)
		
		infos_txt = [ \
			"Title", \
			"Original Script", \
			"Original Translation", \
			"Original Editing", \
			"Original Timing", \
			"Original Script Checking", \
			"Script Updated By", \
			"Update Details", \
			"Synch Point", \
			"ScriptType", \
			"Collisions", \
			"PlayResX", \
			"PlayResY", \
			"PlayDepth", \
			"Timer", \
			"WrapStyle" ]

		for txt in infos_txt:
			if txt == "ScriptType":
				self.infos[txt] = "v4.00+"
			if self.infos.has_key( txt ):
				f_ass.write( "%s: %s" % ( txt, self.infos[txt] ) + endline )
		
		f_ass.write( endline + "[V4+ Styles]" + endline )
		f_ass.write( "Format: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding" + endline )
		for style_name in self.styles.keys():
			entry = self.styles[style_name]
			f_ass.write( "Style: %s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s%s" % ( \
				style_name, \
				entry[ASS_STYLE_COL_Fontname], \
				entry[ASS_STYLE_COL_Fontsize], \
				entry[ASS_STYLE_COL_PrimaryColour], \
				entry[ASS_STYLE_COL_SecondaryColour], \
				entry[ASS_STYLE_COL_OutlineColour], \
				entry[ASS_STYLE_COL_BackColour], \
				entry[ASS_STYLE_COL_Bold], \
				entry[ASS_STYLE_COL_Italic], \
				entry[ASS_STYLE_COL_Underline], \
				entry[ASS_STYLE_COL_StrikeOut], \
				entry[ASS_STYLE_COL_ScaleX], \
				entry[ASS_STYLE_COL_ScaleY], \
				entry[ASS_STYLE_COL_Spacing], \
				entry[ASS_STYLE_COL_Angle], \
				entry[ASS_STYLE_COL_BorderStyle], \
				entry[ASS_STYLE_COL_Outline], \
				entry[ASS_STYLE_COL_Shadow], \
				entry[ASS_STYLE_COL_Alignment], \
				entry[ASS_STYLE_COL_MarginL], \
				entry[ASS_STYLE_COL_MarginR], \
				entry[ASS_STYLE_COL_MarginV], \
				entry[ASS_STYLE_COL_Encoding], \
				endline ) )
		
		f_ass.write( endline + "[Events]" +endline )
		f_ass.write( "Format: Layer, Start, End, Style, Actor, MarginL, MarginR, MarginV, Effect, Text" + endline )

		model = app.events_model
		iter = model.get_iter_root()
		file_enc = locale.getlocale()[1]
		while iter != None:
			entry = app.tree_get_row( iter )
			iter = model.iter_next( iter )
			
			sub_enc = file_enc
			gtk_enc = "utf-8"
			if self.styles[entry[SSA_COL_Style]][ASS_STYLE_COL_Encoding] == 128:
				sub_enc = "shift-jis"
			f_ass.write( "%s: %s,%s,%s,%s,%s,%s,%s,%s,%s,%s%s" % (
				entry[SSA_COL_Flag], \
				entry[SSA_COL_Marked], \
				entry[SSA_COL_Start], \
				entry[SSA_COL_End], \
				entry[SSA_COL_Style].encode( file_enc ), \
				entry[SSA_COL_Name].encode( file_enc ), \
				entry[SSA_COL_MarginL], \
				entry[SSA_COL_MarginR], \
				entry[SSA_COL_MarginV], \
				entry[SSA_COL_Effect	], \
				entry[SSA_COL_Subtitle].encode( sub_enc ),
				endline ) )
		f_ass.write( endline )
		return filename_export
	# save_ass()

	### New SUB
	def set_new( self, app ):
		self.infos = {}
		self.infos["Title"] = ""
		self.infos["Original Script"] = ""
		self.infos["Original Translation"] = ""
		self.infos["Original Editing"] = ""
		self.infos["Original Timing"] = ""
		self.infos["Original Script Checking"] = ""
		self.infos["Script Updated By"] = ""
		self.infos["Update Details"] = ""
		self.infos["Synch Point"] = ""
		self.infos["ScriptType"] = "v4.00"
		self.infos["Collisions"] = "Normal"
		self.infos["PlayResX"] = "640"
		self.infos["PlayResY"] = "480"
		self.infos["PlayDepth"] = "24"
		self.infos["Timer"] = "100.00"
		self.infos["WrapStyle"] = "0"
		
		self.styles = { "Default":self.empty_style }
		self.names = { "~":1 }
		self.nb_rows = 0
		app.get_widget( "start" ).set_text( "0:00:00.00" )
		app.get_widget( "end" ).set_text( "0:00:00.00" )
		app.get_widget( "combo_name" ).set_popdown_strings( [ "~" ] )
		app.get_widget( "combo_style" ).set_popdown_strings( [ "Default" ] )
		app.get_widget( "comment_but" ).set_active( gtk.FALSE )
		app.get_widget( "subtitle" ).set_text( "" )
		app.events_model.clear()
		self.selected_row = app.tree_append_row( None, self.empty_event )
		
		app.get_widget( "events" ).get_selection().select_iter( self.selected_row )
		app.get_widget( "events" ).grab_focus()
		on_list_selected_row( app.get_widget( "events" ).get_selection(), app )
		
		app.set_status( _("Window cleaned.") )
	# set_new()

### / End class c_sub
