#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

##  This file is part of orm, The Object Relational Membrane Version 2.
##
##  Copyright 2002-2006 by Diedrich Vorberg <diedrich@tux4web.de>
##
##  All Rights Reserved
##
##  For more Information on orm see the README file.
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##
##  I have added a copy of the GPL in the file COPYING

# Changelog
# ---------
#
# $Log: datasource.py,v $
# Revision 1.2  2005/12/31 18:32:49  diedrich
# To be deleted...
#
# Revision 1.1  2005/12/18 22:33:43  diedrich
# Initial commit
#
#
#

"""
This datasouce module is for testing purposes only. It is used by the unit
tests.
"""

__author__ = "Diedrich Vorberg <diedrich@tux4web.de>"
__version__ = "$Revision: 1.2 $"[11:-2]

# Python
from types import *

# orm
from orm2.debug import sqllog, debug
from orm2.exceptions import *
import orm2.datasource

from database import database

class datasource(orm2.datasource.datasource_base):
    """
    A test datasource. The test_data parameters goes into the
    test_connection that this datasource uses. 
    """

    queries = []
    
    def __init__(self, test_data = {}, encoding = "iso-8859-1"):
        orm2.datasource.datasource_base.__init__(self)

        self.test_data = test_data
        self._conn = database(self)
        self.encoding = encoding

        self._update_cursor = self.cursor()

    def _from_params(params):
        return datasource()

    from_params = staticmethod(_from_params)

    def cursor(self):
        return self._dbconn().cursor()

    def backend_encoding(self):
        return self.encoding

    def last_query(self):
        if len(self.queries) == 0:
            raise Exception("No query, yet")
        else:
            return self.queries[-1]


    def select_after_insert_where(self, dbobj):
        return "<new-row-where>"
