#include "earray.h"

earray_t 
earray_get (const char *line)
{
  earray_t recarray = NULL;
  int size = 0, i = 0;
  int sizeofint = sizeof (int);
  const char delimiters[] = " ";
  char *token;
  char *cp = strdup (line);
  
  token = strtok (cp, delimiters);

  while (token)
  {
      size += sizeofint;
      recarray = realloc (recarray, size);
      if (recarray == NULL) {
        syslog(LOG_ERR, "Allocation for array of fingers filed!");
	return (NULL);
      }

      recarray[i] = atoi (token);

      i++;
      token = strtok (NULL, delimiters);
  }

  size += sizeofint;
  recarray = realloc (recarray, size);
  if (recarray == NULL) {
    syslog(LOG_ERR, "Allocation for array of fingers filed!");
    return (NULL);
  }
  recarray[i] = EARRAY_END;

  return recarray;
}

/* return 1 if type is in earray, 0 otherwise */
int
earray_isInArray (earray_t earray, int type) {
  int result = 0;
  int i;
  if (earray != NULL) {
    for (i=0; earray[i] != EARRAY_END; i++) {
      if (earray[i] == type) {
	result = 1;
	break;
      }
    }
  }

  return result;
}
