/*
 * bioapi_chbird.h
 * 
 */
#ifndef _BIOAPI_CHBIRD_H
#define _BIOAPI_CHBIRD_H

#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <unistd.h>
#include <pwd.h> /* defines 'struct passwd', and getpwnam(). */
#include <sys/types.h> /* defines 'uid_t', etc.              */
#include <sys/stat.h>
#include <signal.h>
#include <sqlite3.h>

#include <birdb.h>
#include <int_bioapi.h>

#define DEFCONFPATH "/etc/bioapi/birdb.conf"

#define DEFBIRDBPATH "/etc/bioapi/biopasswd.db"
#define MAXSQLSELECT 300
#define SQLCREATETABLE "CREATE TABLE biodata (id INTEGER PRIMARY KEY,uid INTEGER,uuid TEXT,header BLOB,data BLOB,signature BLOB,type INTEGER,other BLOB);"

#define MAXUSERNAME  256
#define MAXPAYLOAD   2048
#define MAXMSG 2051

//#define DEBUG

#ifdef DEBUG
int debug = 1;
#else
int debug = 0;
#endif

static const struct bioapi_version version = { 1, 10 };

typedef struct {
	int tries;
	int getUsername;
	int useDriverGui;
	int type;
	int payloadToBIR;
	char *payload;
	const char *uuidString;
	char *user;
	char *msgfile;
	char *dbbackend;
	char *backendConf;
	int showAllMessages;
} options_t;

/*
 */
typedef struct {
        BioAPI_HANDLE bspHandle;  
} bioapistuff_t;

static int parse_msgfile(const char *path, char **msg[]);
static int
pam_conversation (int                        nmsgs,
                  const struct pam_message **msg,
                  struct pam_response      **resp,
                  void                      *closure);
static void su_sighandler(int);

#endif
