/*-
 * Copyright (c) 2006 Fredrik Lindberg. <fli at shapeshifter dot se>
 * Copyright (c) 2006 Josef Hajas. <josef at hajas dot net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: int_bioapi.h,v 1.4 2006/12/23 12:32:28 nax Exp $
 */

#ifndef _INT_BIOAPI_H_
#define _INT_BIOAPI_H_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/queue.h>
#include <netinet/in.h>
#include <bioapi.h>
#include <bioapi_schema.h>
#include <bioapi_uuid.h>
#include <bioapi_util.h>
#include <security/_pam_types.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>
#include <signal.h>

#include <birdb.h>

sig_atomic_t cancel_bioapi;

/*
 * libbirdb stuff
 */
typedef struct {
  	birdb *bdb;
        struct birdb_mod *bm;
	void *beh;
} dbstuff_t;

/*
 * Callback state, passed to bioapi_guicallback
 */
struct callbackh {
        int prevMsg;
        int showAll;
};

int bioapi_init(void);
void bioapi_destroy(void);
BioAPI_HANDLE * bioapi_attach_bsp(const char *);
void bioapi_detach_bsp(BioAPI_HANDLE *, const char *);
void bioapi_freebir(BioAPI_BIR *);
//struct birdb_rec * bioapi_enroll(BioAPI_HANDLE *, const char *user, int type,
//    int payloadToBir, const char *payload);
BioAPI_BIR_PTR bioapi_capture_for_enroll (BioAPI_HANDLE * handle);
struct birdb_rec *bioapi_enroll (BioAPI_HANDLE * handle, 
    BioAPI_BIR_PTR bir,
    const char *user, int type, 
    int payloadToBir, const char *payload);
int bioapi_verify(BioAPI_HANDLE *, struct birdb_rec *);
int bioapi_verify_many(BioAPI_HANDLE *, struct birdb_rec **);
int bioapi_identify(BioAPI_HANDLE *, struct birdb_mod *, void *, char **, char **);
struct birdb_rec * bioapi_bir_in_db (dbstuff_t dbstuff, BioAPI_HANDLE bspHandle, 
    BioAPI_BIR_PTR bir);
int bioapi_set_gui_callback(BioAPI_HANDLE, struct callbackh *);
BioAPI_RETURN bioapi_guicallback(void *, BioAPI_GUI_STATE,
     BioAPI_GUI_RESPONSE, BioAPI_GUI_MESSAGE ,
     BioAPI_GUI_PROGRESS, BioAPI_GUI_BITMAP_PTR );
void bioapi_error_code(const char *, const BioAPI_RETURN );

//message table
#define KNOWN_MESSAGE_COUNT 38
static char * CallBackMessages[KNOWN_MESSAGE_COUNT]=
{"Scanned good image",			//		0
"No finger detected",  			//		1
"Finger image is too light",		//		2
"Finger is too dry",			//            	3
"Finger image is too dark",		//	     	4
"Finger is too high",			//              5
"Finger is too low",			//              6
"Finger is too left",			//              7
"Finger is too right",			//              8
"Finger image is too small",		//            	9
"Finger image is too strange",		//           	10
"Finger has bad quality",		//           	11
"Put finger",				//		12
"Put finger 2nd time",			//		13
"Put finger 3rd time",			//		14
"Remove finger",			//         	15
"Consolidation failed",			//    		16
"Consolidation succeed",		//		17
"Clean the sensor",			//		18
"Keep finger on the sensor",		//          	19
"Non specific GUI start",		//              20
//"GUI start for verification",		//         	21
"Please wait...",			//         	21
"GUI start for enrollment",		//          	22
//"GUI start for finger detection",	//   		23
"",	//   		23
//"GUI finished without specification of success of biometric operation",	//24
"",	//24
//"GUI finished signaling success of biometric operation",// 25
"",// 25
//"GUI finished signaling failure of biometric operation",//26
"",//26
//"GUI start for sensor calibration",	//		27
"",	//		27
"Finger was swiped too fast",		//		28
"Finger was too skewed during swipe",	//		29
"Finger swipe was too short",		//     		30
"Touch sensor with finger",		//  		31
"Image processing started",		//      	32
"Finger swipe is in progress",		//     		33
"Backward movement detected",		//   		34
"Finger joint detected",		//		35
"Center finger and press harder",	//		36
"Image processing finished"};		//		37

#endif /* _INT_BIOAPI_H_ */
